/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.targetinformation;

import com.google.common.base.Preconditions;

public final class RegisterDescription {
    private final String name;
    private final int byteSize;
    private final boolean isEditable;

    public RegisterDescription(String name, int size, boolean editable) {
        this.name = Preconditions.checkNotNull(name, "IE01031: Name argument can not be null");
        if (!RegisterDescription.isValidSize(size)) {
            throw new IllegalArgumentException(String.format("IE01032: Invalid register size %d", size));
        }
        this.byteSize = size;
        this.isEditable = editable;
    }

    private static boolean isValidSize(int size) {
        return size == 0 || size == 1 || size == 2 || size == 4 || size == 8;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.byteSize;
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

