/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.remotebrowser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteDirectory;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteDrive;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class RemoteFileSystem {
    private final RemoteDirectory directory;
    private final List<RemoteDrive> drives;
    private final List<RemoteDirectory> directories;
    private final List<RemoteFile> files;

    private RemoteFileSystem(RemoteDirectory directory, List<RemoteDrive> drives, List<RemoteDirectory> directories, List<RemoteFile> files) {
        this.directory = directory;
        this.drives = new ArrayList<RemoteDrive>(drives);
        this.directories = new ArrayList<RemoteDirectory>(directories);
        this.files = new ArrayList<RemoteFile>(files);
    }

    private static void parseDirectoriesInformation(Node registersNode, List<RemoteDirectory> files) {
        NodeList nodes = registersNode.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if (!"Directory".equals(nodeName)) continue;
            files.add(new RemoteDirectory(node.getAttributes().getNamedItem("name").getNodeValue()));
        }
    }

    private static void parseDrivesInformation(Node registersNode, List<RemoteDrive> drives) {
        NodeList nodes = registersNode.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if (!"Drive".equals(nodeName)) continue;
            drives.add(new RemoteDrive(node.getAttributes().getNamedItem("name").getNodeValue()));
        }
    }

    private static void parseFilesInformation(Node registersNode, List<RemoteFile> files) {
        NodeList nodes = registersNode.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if (!"File".equals(nodeName)) continue;
            files.add(new RemoteFile(node.getAttributes().getNamedItem("name").getNodeValue()));
        }
    }

    public static RemoteFileSystem parse(byte[] data) throws ParserConfigurationException, SAXException, IOException {
        Preconditions.checkNotNull(data, "IE00771: Data argument can not be null");
        RemoteDirectory directory = null;
        ArrayList<RemoteDrive> drives = new ArrayList<RemoteDrive>();
        ArrayList<RemoteDirectory> directories = new ArrayList<RemoteDirectory>();
        ArrayList<RemoteFile> files = new ArrayList<RemoteFile>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
        NodeList nodes = document.getFirstChild().getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if ("Drives".equals(nodeName)) {
                RemoteFileSystem.parseDrivesInformation(node, drives);
                continue;
            }
            if ("Directories".equals(nodeName)) {
                RemoteFileSystem.parseDirectoriesInformation(node, directories);
                continue;
            }
            if ("Files".equals(nodeName)) {
                RemoteFileSystem.parseFilesInformation(node, files);
                continue;
            }
            if ("Directory".equals(nodeName)) {
                directory = new RemoteDirectory(node.getAttributes().getNamedItem("name").getNodeValue());
                continue;
            }
            String string2 = String.valueOf(nodeName);
            NaviLogger.severe(string2.length() != 0 ? "Error: Unknown node name ".concat(string2) : new String("Error: Unknown node name "), new Object[0]);
        }
        return new RemoteFileSystem(directory, drives, directories, files);
    }

    public List<RemoteDirectory> getDirectories() {
        return new ArrayList<RemoteDirectory>(this.directories);
    }

    public RemoteDirectory getDirectory() {
        return this.directory;
    }

    public List<RemoteDrive> getDrives() {
        return new ArrayList<RemoteDrive>(this.drives);
    }

    public List<RemoteFile> getFiles() {
        return new ArrayList<RemoteFile>(this.files);
    }
}

