/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.memmanager.Memory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class ProcessManager {
    private final ListenerProvider<ProcessManagerListener> listeners = new ListenerProvider();
    private TargetInformation targetInformation;
    private final Memory simulatedProcessMemory = new Memory();
    private MemoryMap memoryMap = new MemoryMap(new ArrayList<MemorySection>());
    private boolean isDebuggerAttached = false;
    private final List<MemoryModule> addressSpaceModules = new ArrayList<MemoryModule>();
    private final TreeSet<IAddress> moduleAddresses = new TreeSet();
    private final Map<IAddress, MemoryModule> moduleByAddress = new HashMap<IAddress, MemoryModule>();
    private final HashSet<TargetProcessThread> activeProcessThreads = new HashSet();
    private TargetProcessThread debuggeeActiveThread = null;

    public void addExceptionEvent(DebuggerException exception) {
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.raisedException(exception);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void addListener(ProcessManagerListener listener) {
        this.listeners.addListener(listener);
    }

    public void addModule(MemoryModule module) {
        Preconditions.checkNotNull(module, "IE00756: Module argument can not be null");
        if (this.addressSpaceModules.contains(module)) {
            throw new IllegalStateException("IE00757: Module can not be added twice");
        }
        this.addressSpaceModules.add(module);
        this.moduleAddresses.add(module.getBaseAddress().getAddress());
        this.moduleByAddress.put(module.getBaseAddress().getAddress(), module);
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.addedModule(module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addThread(TargetProcessThread thread2) {
        Preconditions.checkNotNull(thread2, "IE00766: Thread argument can not be null");
        this.activeProcessThreads.add(thread2);
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.addedThread(thread2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public TargetProcessThread getActiveThread() {
        return this.debuggeeActiveThread;
    }

    public Memory getMemory() {
        return this.simulatedProcessMemory;
    }

    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    public MemoryModule getModule(RelocatedAddress address) {
        NavigableSet<IAddress> moduleAddressesHeadSet = this.moduleAddresses.headSet(address.getAddress(), true);
        if (moduleAddressesHeadSet.isEmpty()) {
            return null;
        }
        MemoryModule module = this.moduleByAddress.get(moduleAddressesHeadSet.last());
        BigInteger endAddress = module.getBaseAddress().getAddress().toBigInteger().add(BigInteger.valueOf(module.getSize()));
        return address.getAddress().toBigInteger().compareTo(endAddress) <= 0 ? module : null;
    }

    public List<MemoryModule> getModules() {
        return new ArrayList<MemoryModule>(this.addressSpaceModules);
    }

    public TargetInformation getTargetInformation() {
        return this.targetInformation;
    }

    public TargetProcessThread getThread(long tid) throws MaybeNullException {
        for (TargetProcessThread thread2 : this.activeProcessThreads) {
            if (thread2.getThreadId() != tid) continue;
            return thread2;
        }
        throw new MaybeNullException();
    }

    public List<TargetProcessThread> getThreads() {
        return new ArrayList<TargetProcessThread>(this.activeProcessThreads);
    }

    public boolean isAttached() {
        return this.isDebuggerAttached;
    }

    public void removeListener(ProcessManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void removeModule(MemoryModule module) {
        Preconditions.checkNotNull(module, "IE00758: Module argument can not be null");
        if (!this.addressSpaceModules.remove(module)) {
            throw new IllegalStateException("IE00759: Module was not part of this process");
        }
        this.moduleAddresses.remove(module.getBaseAddress().getAddress());
        this.moduleByAddress.remove(module.getBaseAddress().getAddress());
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.removedModule(module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeNonExistingModule(MemoryModule module) {
        Preconditions.checkNotNull(module, "IE02256: E00084: Module argument can not be null");
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.removedNonExistingModule(module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeThread(TargetProcessThread thread2) {
        this.activeProcessThreads.remove(thread2);
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.removedThread(thread2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setActiveThread(TargetProcessThread thread2) {
        if (this.debuggeeActiveThread == thread2) {
            return;
        }
        if (thread2 != null && !this.activeProcessThreads.contains(thread2)) {
            throw new IllegalStateException("IE00369: Unknown thread");
        }
        TargetProcessThread oldThread = this.debuggeeActiveThread;
        this.debuggeeActiveThread = thread2;
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.changedActiveThread(oldThread, thread2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setAttached(boolean value) {
        this.isDebuggerAttached = value;
        for (ProcessManagerListener listener : this.listeners) {
            try {
                if (value) {
                    listener.attached();
                    continue;
                }
                listener.detached();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setMemoryMap(MemoryMap memoryMap) {
        this.memoryMap = Preconditions.checkNotNull(memoryMap, "IE00760: Memory map can't be null");
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.changedMemoryMap();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setTargetInformation(TargetInformation targetInformation) {
        Preconditions.checkNotNull(targetInformation, "IE00761: Target information argument can not be null");
        this.targetInformation = targetInformation;
        for (ProcessManagerListener listener : this.listeners) {
            try {
                listener.changedTargetInformation(this.targetInformation);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

