/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public final class MemorySection {
    private final IAddress memorySectionStartAddress;
    private final IAddress memorySectionEndAddress;

    public MemorySection(IAddress start, IAddress end) {
        this.memorySectionStartAddress = Preconditions.checkNotNull(start, "IE00753: Section start can not be null");
        this.memorySectionEndAddress = Preconditions.checkNotNull(end, "IE00754: Section end can not be null");
        Preconditions.checkArgument(end.toBigInteger().compareTo(start.toBigInteger()) != -1, "IE00755: Section end can not come before section start");
    }

    public IAddress getEnd() {
        return this.memorySectionEndAddress;
    }

    public int getSize() {
        return (int)(this.memorySectionEndAddress.toLong() - this.memorySectionStartAddress.toLong()) + 1;
    }

    public IAddress getStart() {
        return this.memorySectionStartAddress;
    }

    public String toString() {
        return String.format("%s - %s", this.memorySectionStartAddress, this.memorySectionEndAddress);
    }
}

