/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;

public final class MemoryModule {
    private final String name;
    private final String path;
    private final RelocatedAddress relocatedAddress;
    private final long byteSize;

    public MemoryModule(String name, String path, RelocatedAddress baseAddress, long size) {
        this.name = Preconditions.checkNotNull(name, "IE00751: Name argument can not be null");
        this.path = Preconditions.checkNotNull(path, "IE00180: Path argument can not be null");
        this.relocatedAddress = Preconditions.checkNotNull(baseAddress, "IE00752: Base address argument can not be null");
        this.byteSize = size;
    }

    public RelocatedAddress getBaseAddress() {
        return this.relocatedAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.byteSize;
    }

    public String toString() {
        String string2 = this.getName();
        String string3 = this.getPath();
        String string4 = String.valueOf(this.getBaseAddress().getAddress().toHexString());
        return new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(", ").append(string3).append(": ").append(string4).toString();
    }
}

