/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processmanager;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MemoryMap
implements Iterable<MemorySection> {
    private final List<MemorySection> memorySections;

    public MemoryMap(List<MemorySection> sections) {
        Preconditions.checkNotNull(sections, "IE00747: Section list can not be null");
        for (MemorySection section : sections) {
            Preconditions.checkNotNull(section, "IE00748: Section can not be null");
        }
        this.memorySections = new ArrayList<MemorySection>(sections);
    }

    public MemorySection findOffset(BigInteger offset) {
        Preconditions.checkNotNull(offset, "IE00749: Offset argument can not be null");
        for (MemorySection section : this.memorySections) {
            if (section.getStart().toBigInteger().compareTo(offset) > 0 || section.getEnd().toBigInteger().compareTo(offset) < 0) continue;
            return section;
        }
        return null;
    }

    public int getNumberOfSections() {
        return this.memorySections.size();
    }

    public MemorySection getSection(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.memorySections.size(), "IE00750: Invalid section index");
        return this.memorySections.get(index);
    }

    @Override
    public Iterator<MemorySection> iterator() {
        return this.memorySections.iterator();
    }
}

