/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processlist;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.models.processlist.ProcessDescription;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ProcessList
implements Iterable<ProcessDescription> {
    private final List<ProcessDescription> processes;

    private ProcessList(List<ProcessDescription> processes) {
        this.processes = processes;
    }

    public static ProcessList parse(byte[] data) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<ProcessDescription> processes = new ArrayList<ProcessDescription>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
        NodeList nodes = document.getFirstChild().getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            String nodeName = node.getNodeName();
            if ("Process".equals(nodeName)) {
                String pid = node.getAttributes().getNamedItem("pid").getNodeValue();
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                processes.add(new ProcessDescription(Integer.valueOf(pid), name));
                continue;
            }
            String string2 = String.valueOf(nodeName);
            NaviLogger.severe(string2.length() != 0 ? "Error: Unknown node name ".concat(string2) : new String("Error: Unknown node name "), new Object[0]);
        }
        return new ProcessList(processes);
    }

    public ProcessDescription get(int index) {
        return this.processes.get(index);
    }

    @Override
    public Iterator<ProcessDescription> iterator() {
        return this.processes.iterator();
    }

    public int size() {
        return this.processes.size();
    }
}

