/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.helpers;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.HashSet;
import java.util.Set;

public final class EchoBreakpointCollector
implements INodeCallback<NaviNode> {
    private final BreakpointManager manager;
    private final Set<BreakpointAddress> echoBreakpointAbleAddresses = new HashSet<BreakpointAddress>();

    public EchoBreakpointCollector(BreakpointManager manager) {
        this.manager = manager;
    }

    public static boolean isBlocked(BreakpointManager manager, BreakpointAddress address) {
        return manager.hasBreakpoint(BreakpointType.REGULAR, address) && manager.getBreakpointStatus(address, BreakpointType.REGULAR) != BreakpointStatus.BREAKPOINT_DISABLED || manager.hasBreakpoint(BreakpointType.ECHO, address) || manager.hasBreakpoint(BreakpointType.STEP, address);
    }

    public Set<BreakpointAddress> getBreakpoints() {
        return this.echoBreakpointAbleAddresses;
    }

    @Override
    public IterationMode next(NaviNode node) {
        INaviViewNode viewNode = node.getRawNode();
        if (viewNode instanceof INaviCodeNode) {
            INaviCodeNode codeNode = (INaviCodeNode)viewNode;
            INaviInstruction instruction = Iterables.getFirst(codeNode.getInstructions(), null);
            INaviModule module = instruction.getModule();
            BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(instruction.getAddress()));
            if (EchoBreakpointCollector.isBlocked(this.manager, address)) {
                return IterationMode.CONTINUE;
            }
            NaviLogger.info("Adding Echo breakpoint %s to the active list", address.getAddress().getAddress().toHexString());
            this.echoBreakpointAbleAddresses.add(address);
        } else if (viewNode instanceof INaviFunctionNode) {
            INaviFunctionNode functionNode = (INaviFunctionNode)viewNode;
            INaviModule module = functionNode.getFunction().getModule();
            BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(functionNode.getFunction().getAddress()));
            if (EchoBreakpointCollector.isBlocked(this.manager, address)) {
                return IterationMode.CONTINUE;
            }
            NaviLogger.info("Adding Echo breakpoint %s to the active list", address.getAddress().getAddress().toHexString());
            this.echoBreakpointAbleAddresses.add(address);
        }
        return IterationMode.CONTINUE;
    }
}

