/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.helpers;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.debug.helpers.EchoBreakpointCollector;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class BreakpointableNodeCounter
implements INodeCallback<NaviNode> {
    private final BreakpointManager breakpointManager;
    private int breakpointAbleNodeCount = 0;

    public BreakpointableNodeCounter(BreakpointManager manager) {
        this.breakpointManager = manager;
    }

    public int getCount() {
        return this.breakpointAbleNodeCount;
    }

    @Override
    public IterationMode next(NaviNode node) {
        INaviViewNode viewNode = node.getRawNode();
        if (viewNode instanceof INaviCodeNode) {
            INaviCodeNode codeNode = (INaviCodeNode)viewNode;
            INaviInstruction instruction = Iterables.getFirst(codeNode.getInstructions(), null);
            INaviModule module = instruction.getModule();
            BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(instruction.getAddress()));
            if (EchoBreakpointCollector.isBlocked(this.breakpointManager, address)) {
                return IterationMode.CONTINUE;
            }
            ++this.breakpointAbleNodeCount;
        } else if (viewNode instanceof INaviFunctionNode) {
            INaviFunctionNode functionNode = (INaviFunctionNode)viewNode;
            INaviModule module = functionNode.getFunction().getModule();
            BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(functionNode.getFunction().getAddress()));
            if (EchoBreakpointCollector.isBlocked(this.breakpointManager, address)) {
                return IterationMode.CONTINUE;
            }
            ++this.breakpointAbleNodeCount;
        }
        return IterationMode.CONTINUE;
    }
}

