/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;

public class ThreadStateSynchronizer {
    private final IDebugger debugger;
    private final ThreadListener m_threadListener = new ThreadListenerAdapter(){

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            if (thread2.getState() == ThreadState.RUNNING) {
                try {
                    ThreadStateSynchronizer.this.debugger.resumeThread(thread2.getThreadId());
                }
                catch (DebugExceptionWrapper exception) {
                    NaviLogger.severe("Error: Debugger could not resume thread. Exception %s", exception);
                }
            } else {
                try {
                    ThreadStateSynchronizer.this.debugger.suspendThread(thread2.getThreadId());
                }
                catch (DebugExceptionWrapper exception) {
                    NaviLogger.severe("Error: Debugger could not suspend thread. Exception %s", exception);
                }
            }
        }
    };
    private final ProcessManagerListener m_processListener = new ProcessManagerListenerAdapter(){

        @Override
        public void addedThread(TargetProcessThread thread2) {
            thread2.addListener(ThreadStateSynchronizer.this.m_threadListener);
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            thread2.removeListener(ThreadStateSynchronizer.this.m_threadListener);
        }
    };

    public ThreadStateSynchronizer(IDebugger debugger) {
        this.debugger = debugger;
        for (TargetProcessThread thread2 : this.debugger.getProcessManager().getThreads()) {
            thread2.addListener(this.m_threadListener);
        }
        this.debugger.getProcessManager().addListener(this.m_processListener);
    }
}

