/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TargetInformationReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class TargetInformationSynchronizer
extends ReplySynchronizer<TargetInformationReply> {
    public TargetInformationSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(TargetInformationReply reply) {
        IDebugger debugger = this.getDebugger();
        ProcessManager processManager = this.getDebugger().getProcessManager();
        TargetInformation info = reply.getTargetInformation();
        processManager.setTargetInformation(info);
        if (info.getDebuggerOptions().canMemmap()) {
            try {
                debugger.getMemoryMap();
            }
            catch (DebugExceptionWrapper e2) {
                NaviLogger.severe("Error: Debugger could not get memory map. Exception %s", e2);
                this.issueDebugException(e2);
            }
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, TargetInformationReply reply) {
        listener.receivedReply(reply);
    }
}

