/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SuspendThreadReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class SuspendThreadSynchronizer
extends ReplySynchronizer<SuspendThreadReply> {
    public SuspendThreadSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleError(SuspendThreadReply reply) {
        try {
            TargetProcessThread thread2 = this.getDebugger().getProcessManager().getThread(reply.getThreadId());
            thread2.setState(ThreadState.RUNNING);
        }
        catch (MaybeNullException exception) {
            NaviLogger.severe("Error: Tried to suspend unknown thread '%d'", reply.getThreadId());
        }
    }

    @Override
    protected void handleSuccess(SuspendThreadReply reply) {
        try {
            TargetProcessThread thread2 = this.getDebugger().getProcessManager().getThread(reply.getThreadId());
            thread2.setState(ThreadState.SUSPENDED);
        }
        catch (MaybeNullException exception) {
            NaviLogger.severe("Error: Tried to suspend unknown thread '%d'", reply.getThreadId());
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, SuspendThreadReply reply) {
        listener.receivedReply(reply);
    }
}

