/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.HashSet;

public final class StepBreakpointSetSynchronizer
extends ReplySynchronizer<StepBreakpointSetReply> {
    public StepBreakpointSetSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(StepBreakpointSetReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        HashSet<BreakpointAddress> addressesToActivate = new HashSet<BreakpointAddress>();
        HashSet<BreakpointAddress> addressesToRemove = new HashSet<BreakpointAddress>();
        for (Pair<RelocatedAddress, Integer> resultPair : reply.getAddresses()) {
            RelocatedAddress address = resultPair.first();
            if (resultPair.second() == 0) {
                addressesToActivate.add(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), address));
                continue;
            }
            addressesToRemove.add(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), address));
        }
        manager.setBreakpointStatus(addressesToActivate, BreakpointType.STEP, BreakpointStatus.BREAKPOINT_ACTIVE);
        manager.removeBreakpoints(BreakpointType.STEP, addressesToRemove);
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, StepBreakpointSetReply reply) {
        listener.receivedReply(reply);
    }
}

