/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class StepBreakpointHitSynchronizer
extends ReplySynchronizer<StepBreakpointHitReply> {
    public StepBreakpointHitSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(StepBreakpointHitReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        ProcessManager processManager = this.getDebugger().getProcessManager();
        RelocatedAddress breakpointAddress = null;
        RegisterValues registerValues = reply.getRegisterValues();
        long tid = reply.getThreadId();
        block2: for (ThreadRegisters threadRegisters : registerValues) {
            if (tid != threadRegisters.getTid()) continue;
            for (RegisterValue registerValue : threadRegisters) {
                if (!registerValue.isPc()) continue;
                breakpointAddress = new RelocatedAddress(new CAddress(registerValue.getValue()));
                continue block2;
            }
        }
        manager.clearBreakpointsPassive(BreakpointType.STEP);
        try {
            TargetProcessThread thread2 = processManager.getThread(tid);
            for (ThreadRegisters threadRegisters : registerValues) {
                if (tid != threadRegisters.getTid()) continue;
                thread2.setRegisterValues(threadRegisters.getRegisters());
            }
            processManager.setActiveThread(thread2);
            thread2.setCurrentAddress(breakpointAddress);
        }
        catch (MaybeNullException exception) {
            NaviLogger.info("Error: Process manager could not get thread. Exception %s", exception);
            return;
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, StepBreakpointHitReply reply) {
        listener.receivedReply(reply);
    }
}

