/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeThreadReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ResumeThreadSynchronizer
extends ReplySynchronizer<ResumeThreadReply> {
    public ResumeThreadSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleError(ResumeThreadReply reply) {
        try {
            TargetProcessThread thread2 = this.getDebugger().getProcessManager().getThread(reply.getThreadId());
            thread2.setState(ThreadState.SUSPENDED);
        }
        catch (MaybeNullException exception) {
            NaviLogger.severe("Error: Tried to resume unknown thread '%d'", reply.getThreadId());
        }
    }

    @Override
    protected void handleSuccess(ResumeThreadReply reply) {
        try {
            TargetProcessThread thread2 = this.getDebugger().getProcessManager().getThread(reply.getThreadId());
            thread2.setState(ThreadState.RUNNING);
        }
        catch (MaybeNullException exception) {
            NaviLogger.severe("Error: Tried to resume unknown thread '%d'", reply.getThreadId());
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ResumeThreadReply reply) {
        listener.receivedReply(reply);
    }
}

