/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ReplySynchronizer<T extends DebuggerReply> {
    private final IDebugger debugger;
    private final ListenerProvider<IDebugEventListener> listeners;

    protected ReplySynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        this.debugger = Preconditions.checkNotNull(debugger, "IE01043: Debugger argument can not be null");
        this.listeners = Preconditions.checkNotNull(listeners, "IE01044: Listeners argument can not be null");
    }

    private void deactivateBreakpoints() {
        BreakpointManager manager = this.debugger.getBreakpointManager();
        HashSet<BreakpointAddress> addressesToRemove = new HashSet<BreakpointAddress>();
        HashSet<BreakpointAddress> addressesToDisable = new HashSet<BreakpointAddress>();
        for (Breakpoint breakpoint : manager.getBreakpoints(BreakpointType.REGULAR)) {
            BreakpointAddress address = breakpoint.getAddress();
            if (manager.getBreakpointStatus(address, BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_DELETING) {
                addressesToRemove.add(address);
                continue;
            }
            if (manager.getBreakpointStatus(address, BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_DISABLED) continue;
            addressesToDisable.add(address);
        }
        manager.removeBreakpoints(BreakpointType.REGULAR, addressesToRemove);
        manager.setBreakpointStatus(addressesToDisable, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_INACTIVE);
    }

    protected IDebugger getDebugger() {
        return this.debugger;
    }

    protected void handleError(T reply) {
    }

    protected void handleSuccess(T reply) {
    }

    protected void issueDebugException(DebugExceptionWrapper debugException) {
        Preconditions.checkNotNull(debugException, "IE01045: Debug exception argument can not be null");
        for (IDebugEventListener listener : this.listeners) {
            try {
                listener.debugException(debugException);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    protected abstract void notifyListener(IDebugEventListener var1, T var2);

    protected void refreshRegisters() {
        try {
            this.debugger.readRegisters();
        }
        catch (DebugExceptionWrapper exception) {
            NaviLogger.severe("Error: Could not read registers: Exception %s", exception);
            for (IDebugEventListener listener : this.listeners) {
                try {
                    listener.debugException(exception);
                }
                catch (Exception exception2) {
                    CUtilityFunctions.logException(exception2);
                }
            }
        }
    }

    protected void resetTargetProcess() {
        BreakpointManager manager = this.debugger.getBreakpointManager();
        ProcessManager processManager = this.debugger.getProcessManager();
        this.debugger.setTerminated();
        manager.clearBreakpointsPassive(BreakpointType.ECHO);
        manager.clearBreakpointsPassive(BreakpointType.STEP);
        this.deactivateBreakpoints();
        processManager.getMemory().clear();
        processManager.setMemoryMap(new MemoryMap(new ArrayList<MemorySection>()));
        List<TargetProcessThread> threads = processManager.getThreads();
        for (TargetProcessThread thread2 : threads) {
            processManager.removeThread(thread2);
        }
        for (MemoryModule module : processManager.getModules()) {
            processManager.removeModule(module);
        }
        processManager.setAttached(false);
        processManager.setActiveThread(null);
    }

    protected void setRegisterValues(RegisterValues registerValues) {
        Preconditions.checkNotNull(registerValues, "IE01046: Register values argument can not be null");
        ProcessManager processManager = this.debugger.getProcessManager();
        for (ThreadRegisters threadRegister : registerValues) {
            for (TargetProcessThread thread2 : processManager.getThreads()) {
                if (thread2.getThreadId() != threadRegister.getTid()) continue;
                thread2.setRegisterValues(threadRegister.getRegisters());
                for (RegisterValue registerValue : threadRegister.getRegisters()) {
                    if (!registerValue.isPc()) continue;
                    thread2.setCurrentAddress(new RelocatedAddress(new CAddress(registerValue.getValue())));
                }
            }
        }
    }

    protected void updateHitBreakpoints(BreakpointAddress address) {
        Preconditions.checkNotNull(address, "IE01048: Address argument can not be null");
        BreakpointManager manager = this.debugger.getBreakpointManager();
        for (Breakpoint breakpoint : manager.getBreakpoints(BreakpointType.REGULAR)) {
            boolean isAddressSame = address.equals(breakpoint.getAddress());
            if (manager.getBreakpointStatus(breakpoint.getAddress(), BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_HIT && !isAddressSame) {
                manager.setBreakpointStatus(Sets.newHashSet(breakpoint.getAddress()), BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ACTIVE);
                break;
            }
            if (!isAddressSame) continue;
            try {
                manager.setBreakpointStatus(Sets.newHashSet(breakpoint.getAddress()), BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_HIT);
            }
            catch (IllegalArgumentException exception) {
                return;
            }
        }
    }

    public void handle(T reply) {
        Preconditions.checkNotNull(reply, "IE01220: Reply argument can not be null");
        if (((DebuggerReply)reply).success()) {
            this.handleSuccess(reply);
        } else {
            this.handleError(reply);
        }
        for (IDebugEventListener listener : this.listeners) {
            try {
                this.notifyListener(listener, reply);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

