/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ReadMemoryReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ReadMemorySynchronizer
extends ReplySynchronizer<ReadMemoryReply> {
    public ReadMemorySynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleError(ReadMemoryReply reply) {
        try {
            this.getDebugger().getMemoryMap();
        }
        catch (DebugExceptionWrapper exception) {
            NaviLogger.severe("Error: Debugger could not ger memory map. Exception %s", exception);
        }
    }

    @Override
    protected void handleSuccess(ReadMemoryReply reply) {
        this.getDebugger().getProcessManager().getMemory().store(reply.getAddress().toLong(), reply.getData());
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ReadMemoryReply reply) {
        listener.receivedReply(reply);
    }
}

