/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CBreakpointModuleSynchronizer;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleUnloadedReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.storage.DebuggerEventSettingsStorage;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ModuleUnloadedSynchronizer
extends ReplySynchronizer<ModuleUnloadedReply> {
    public ModuleUnloadedSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    private boolean needsResume() {
        DebuggerEventSettings settings = null;
        try {
            settings = new DebuggerEventSettingsStorage(this.getDebugger(), this.getDebugger().getDebugTargetSettings()).deserialize();
        }
        catch (CouldntLoadDataException couldntLoadDataException) {
            // empty catch block
        }
        return (settings == null || !settings.getBreakOnDllUnload()) && this.getDebugger().getProcessManager().getTargetInformation().getDebuggerOptions().canBreakOnModuleUnload();
    }

    @Override
    protected void handleSuccess(ModuleUnloadedReply reply) {
        MemoryModule replyModule;
        ProcessManager processManager = this.getDebugger().getProcessManager();
        MemoryModule existingModule = processManager.getModule((replyModule = reply.getModule()).getBaseAddress());
        if (existingModule == null) {
            processManager.removeNonExistingModule(replyModule);
        } else {
            processManager.removeModule(existingModule);
            CBreakpointModuleSynchronizer.disableEchoBreakpoints(this.getDebugger(), existingModule);
            CBreakpointModuleSynchronizer.disableRegularBreakpoints(this.getDebugger(), existingModule);
        }
        if (this.needsResume()) {
            try {
                this.getDebugger().resume();
            }
            catch (DebugExceptionWrapper e2) {
                NaviLogger.severe("Error: Could not resume the debugger. Exception: %s", e2);
            }
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ModuleUnloadedReply reply) {
        listener.receivedReply(reply);
    }
}

