/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CBreakpointModuleSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CRelocationNotifier;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleLoadedReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.storage.DebuggerEventSettingsStorage;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ModuleLoadedSynchronizer
extends ReplySynchronizer<ModuleLoadedReply> {
    public ModuleLoadedSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    private static void setActiveThreadById(ProcessManager processManager, long threadId) {
        try {
            TargetProcessThread thread2 = processManager.getThread(threadId);
            processManager.setActiveThread(thread2);
        }
        catch (MaybeNullException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    private boolean needsResume() {
        DebuggerEventSettings settings = null;
        try {
            settings = new DebuggerEventSettingsStorage(this.getDebugger(), this.getDebugger().getDebugTargetSettings()).deserialize();
        }
        catch (CouldntLoadDataException couldntLoadDataException) {
            // empty catch block
        }
        return settings == null || !settings.getBreakOnDllLoad();
    }

    @Override
    protected void handleSuccess(ModuleLoadedReply reply) {
        this.getDebugger().getProcessManager().addModule(reply.getModule());
        CRelocationNotifier.relocateModule(this.getDebugger(), reply.getModule());
        CBreakpointModuleSynchronizer.enableRegularBreakpoints(this.getDebugger(), reply.getModule());
        CBreakpointModuleSynchronizer.enableEchoBreakpoints(this.getDebugger(), reply.getModule());
        TargetInformation targetInformation = this.getDebugger().getProcessManager().getTargetInformation();
        if (targetInformation != null && targetInformation.getDebuggerOptions().canBreakOnModuleLoad()) {
            if (this.needsResume()) {
                try {
                    this.getDebugger().resume();
                }
                catch (DebugExceptionWrapper e2) {
                    NaviLogger.severe("Error: Could not resume debugger. Exception: %s", e2);
                }
            } else {
                this.refreshRegisters();
                ModuleLoadedSynchronizer.setActiveThreadById(this.getDebugger().getProcessManager(), reply.getThread().getThreadId());
            }
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ModuleLoadedReply reply) {
        listener.receivedReply(reply);
    }
}

