/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;

public final class EchoBreakpointRemovedSynchronizer
extends ReplySynchronizer<EchoBreakpointsRemovedReply> {
    public EchoBreakpointRemovedSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(EchoBreakpointsRemovedReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        for (Pair<RelocatedAddress, Integer> resultPair : reply.getAddresses()) {
            if (resultPair.second() != 0) continue;
            BreakpointAddress address = DebuggerHelpers.getBreakpointAddress(this.getDebugger(), resultPair.first());
            try {
                if (!manager.hasBreakpoint(BreakpointType.ECHO, address)) continue;
                manager.removeBreakpoints(BreakpointType.ECHO, Sets.newHashSet(address));
            }
            catch (IllegalArgumentException ex) {
                NaviLogger.severe("Error: Manager could not remove breakpoint. Exception %s", ex);
            }
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, EchoBreakpointsRemovedReply reply) {
        listener.receivedReply(reply);
    }
}

