/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class EchoBreakpointHitSynchronizer
extends ReplySynchronizer<EchoBreakpointHitReply> {
    public EchoBreakpointHitSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(EchoBreakpointHitReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        long tid = reply.getThreadId();
        block0: for (ThreadRegisters threadRegisters : reply.getRegisterValues()) {
            if (tid != threadRegisters.getTid()) continue;
            for (RegisterValue registerValue : threadRegisters) {
                if (!registerValue.isPc()) continue;
                RelocatedAddress address = new RelocatedAddress(new CAddress(registerValue.getValue()));
                manager.setBreakpointStatus(Sets.newHashSet(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), address)), BreakpointType.ECHO, BreakpointStatus.BREAKPOINT_HIT);
                continue block0;
            }
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, EchoBreakpointHitReply reply) {
        listener.receivedReply(reply);
    }
}

