/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.MemoryLoader;
import com.google.security.zynamics.binnavi.debug.debugger.MemoryRangeCalculator;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IMemoryProvider;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.memmanager.IMemoryListener;
import java.math.BigInteger;

public final class MemorySynchronizer {
    private final IDebugger debugger;
    private final MemoryLoader memoryLoader;
    private final InternalMemoryProvider memoryProvider = new InternalMemoryProvider();
    private final InternalMemoryListener memoryListener = new InternalMemoryListener();
    private final InternalDebugListener debuggerListener = new InternalDebugListener();

    public MemorySynchronizer(IDebugger debugger) {
        this.debugger = Preconditions.checkNotNull(debugger, "IE00816: Debugger argument can not be null");
        this.debugger.addListener(this.debuggerListener);
        this.debugger.getProcessManager().getMemory().addMemoryListener(this.memoryListener);
        this.memoryLoader = new MemoryLoader(debugger);
    }

    public IMemoryProvider getMemoryProvider() {
        return this.memoryProvider;
    }

    private class InternalMemoryProvider
    implements IMemoryProvider {
        private InternalMemoryProvider() {
        }

        @Override
        public boolean hasData(BigInteger offset, int size) {
            Pair<IAddress, Integer> realRange = MemoryRangeCalculator.calculateRequestRange(MemorySynchronizer.this.debugger, offset, size);
            try {
                MemorySynchronizer.this.memoryLoader.requestMemory(realRange.first(), realRange.second());
            }
            catch (DebugExceptionWrapper e2) {
                CUtilityFunctions.logException(e2);
            }
            return MemorySynchronizer.this.memoryLoader.hasData(offset, size);
        }

        @Override
        public boolean hasData(BigInteger cacheOffset, int cacheSize, BigInteger offset, int size) {
            try {
                MemorySynchronizer.this.memoryLoader.requestMemory(new CAddress(offset), size);
            }
            catch (DebugExceptionWrapper e2) {
                CUtilityFunctions.logException(e2);
            }
            return MemorySynchronizer.this.memoryLoader.hasData(cacheOffset, cacheSize);
        }
    }

    private class InternalMemoryListener
    implements IMemoryListener {
        private InternalMemoryListener() {
        }

        @Override
        public void memoryChanged(long address, int size) {
            MemorySynchronizer.this.memoryLoader.received(address, size);
        }

        @Override
        public void memoryCleared() {
            MemorySynchronizer.this.memoryLoader.reset();
        }
    }

    private class InternalDebugListener
    extends DebugEventListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void debuggerClosed(int errorCode) {
            MemorySynchronizer.this.memoryLoader.reset();
        }

        @Override
        public void receivedReply(ProcessClosedReply reply) {
            MemorySynchronizer.this.memoryLoader.reset();
        }
    }
}

