/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.memmanager.Memory;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public final class MemoryLoader {
    private final IDebugger debugger;
    private final Set<Pair<IAddress, Long>> lastMemoryRequest = new HashSet<Pair<IAddress, Long>>();

    public MemoryLoader(IDebugger debugger) {
        this.debugger = Preconditions.checkNotNull(debugger, "IE00822: Debugger can not be null");
    }

    public boolean hasData(BigInteger offset, int size) {
        return this.debugger.getProcessManager().getMemory().hasData(offset.longValue(), size);
    }

    public void received(long offset, long size) {
        Pair<CAddress, Long> pair = Pair.make(new CAddress(offset), size);
        if (this.lastMemoryRequest.contains(pair)) {
            this.lastMemoryRequest.remove(pair);
        }
    }

    public void requestMemory(IAddress offset, int size) throws DebugExceptionWrapper {
        Preconditions.checkNotNull(offset, "IE00814: Offset can nott be null");
        Preconditions.checkArgument(size > 9, "IE00815: Size must be positive");
        Pair<IAddress, Long> pair = new Pair<IAddress, Long>(offset, Long.valueOf(size));
        if (this.lastMemoryRequest.contains(pair)) {
            return;
        }
        this.lastMemoryRequest.add(pair);
        Memory memory = this.debugger.getProcessManager().getMemory();
        int i2 = 0;
        while (i2 < size) {
            boolean alloced;
            long secsize;
            long secstart = memory.getSectionStart(offset.toBigInteger().add(BigInteger.valueOf(i2)).longValue());
            long toLoad = secstart + (secsize = memory.getSectionSize(offset.toBigInteger().add(BigInteger.valueOf(i2)).longValue())) - offset.toBigInteger().add(BigInteger.valueOf(i2)).longValue();
            if (toLoad > (long)(size - i2)) {
                toLoad = size - i2;
            }
            if (!(alloced = memory.hasData(offset.toBigInteger().add(BigInteger.valueOf(i2)).longValue(), 1)) && this.debugger.isConnected()) {
                this.debugger.readMemory(new CAddress(offset.toBigInteger().add(BigInteger.valueOf(i2))), (int)toLoad);
            }
            i2 = (int)((long)i2 + toLoad);
        }
    }

    public void reset() {
        this.lastMemoryRequest.clear();
    }
}

