/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.net.NetHelpers;

public final class DebuggerTemplate
implements IDatabaseObject {
    private final SQLProvider sqlProvider;
    private final ListenerProvider<IDebuggerTemplateListener> listeners = new ListenerProvider();
    private final int debuggerTemplateId;
    private String debuggerTemplateName;
    private String debugClientHost;
    private int debugClientPort;

    public DebuggerTemplate(int debuggerId, String name, String host, int port, SQLProvider sqlProvider) {
        Preconditions.checkArgument(debuggerId > 0, "IE00796: ID argument must be positive");
        this.debuggerTemplateName = Preconditions.checkNotNull(name, "IE00797: Name argument can not be null");
        this.debugClientHost = Preconditions.checkNotNull(host, "IE00798: Host argument can not be null");
        Preconditions.checkArgument(NetHelpers.isValidPort(port), "IE00799: Invalid port argument");
        this.sqlProvider = Preconditions.checkNotNull(sqlProvider, "IE00800: SQL provider argument can not be null");
        this.debuggerTemplateId = debuggerId;
        this.debugClientPort = port;
    }

    public void addListener(IDebuggerTemplateListener listener) {
        this.listeners.addListener(listener);
    }

    public String getHost() {
        return this.debugClientHost;
    }

    public int getId() {
        return this.debuggerTemplateId;
    }

    public String getName() {
        return this.debuggerTemplateName;
    }

    public int getPort() {
        return this.debugClientPort;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00801: Object argument can not be null");
        return object.inSameDatabase(this.sqlProvider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.sqlProvider == provider;
    }

    public void removeListener(IDebuggerTemplateListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setHost(String host) throws CouldntSaveDataException {
        Preconditions.checkNotNull(host, "IE00802: Host argument can not be null");
        if (this.debugClientHost.equals(host)) {
            return;
        }
        this.sqlProvider.setHost(this, host);
        this.debugClientHost = host;
        for (IDebuggerTemplateListener listener : this.listeners) {
            try {
                listener.changedHost(this);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00803: Name argument can not be null");
        if (this.debuggerTemplateName.equals(name)) {
            return;
        }
        this.sqlProvider.setName(this, name);
        this.debuggerTemplateName = name;
        for (IDebuggerTemplateListener listener : this.listeners) {
            try {
                listener.changedName(this);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void setPort(int port) throws CouldntSaveDataException {
        Preconditions.checkArgument(NetHelpers.isValidPort(port), "IE00804: Invalid port");
        if (this.debugClientPort == port) {
            return;
        }
        this.sqlProvider.setPort(this, port);
        this.debugClientPort = port;
        for (IDebuggerTemplateListener listener : this.listeners) {
            try {
                listener.changedPort(this);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public String toString() {
        String string2 = this.debuggerTemplateName;
        String string3 = this.debugClientHost;
        int n2 = this.debugClientPort;
        return new StringBuilder(15 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" - ").append(string3).append(":").append(n2).toString();
    }
}

