/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.DebuggerProviderListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DebuggerProvider
implements BackEndDebuggerProvider {
    private final DebugTargetSettings debugTargetSettings;
    private final List<IDebugger> debuggers = new ArrayList<IDebugger>();
    private final ListenerProvider<DebuggerProviderListener> m_listeners = new ListenerProvider();

    public DebuggerProvider(DebugTargetSettings target) {
        this.debugTargetSettings = Preconditions.checkNotNull(target, "IE01669: target argument can not be null");
    }

    public void addDebugger(IDebugger debugger) {
        this.debuggers.add(Preconditions.checkNotNull(debugger, "IE00195: Debugger argument can not be null"));
        for (DebuggerProviderListener listener : this.m_listeners) {
            try {
                listener.debuggerAdded(this, debugger);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void addListener(DebuggerProviderListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public IDebugger getDebugger(INaviModule module) {
        for (IDebugger debugger : this.debuggers) {
            if (!debugger.canDebug(module)) continue;
            return debugger;
        }
        return null;
    }

    @Override
    public List<IDebugger> getDebuggers() {
        return Lists.newArrayList(this.debuggers);
    }

    @Override
    public DebugTargetSettings getDebugTarget() {
        return this.debugTargetSettings;
    }

    @Override
    public Iterator<IDebugger> iterator() {
        return this.debuggers.iterator();
    }

    public void removeDebugger(IDebugger debugger) {
        this.debuggers.remove(debugger);
        for (DebuggerProviderListener listener : this.m_listeners) {
            try {
                listener.debuggerRemoved(this, debugger);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeListener(DebuggerProviderListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

