/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;

public final class DebuggerHelpers {
    private DebuggerHelpers() {
    }

    public static BreakpointAddress getBreakpointAddress(IDebugger debugger, RelocatedAddress memoryAddress) {
        Preconditions.checkNotNull(debugger, "IE00161: Debugger argument can not be null");
        Preconditions.checkNotNull(memoryAddress, "IE00163: Memory address argument can not be null");
        INaviModule module = debugger.getModule(memoryAddress);
        return new BreakpointAddress(module, module == null ? new UnrelocatedAddress(memoryAddress.getAddress()) : debugger.memoryToFile(module, memoryAddress));
    }
}

