/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers;

import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadCreatedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers.AbstractReplyParser;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import java.io.IOException;

public final class ThreadCreatedParser
extends AbstractReplyParser<ThreadCreatedReply> {
    public ThreadCreatedParser(ClientReader clientReader) {
        super(clientReader, 55);
    }

    private ThreadState convertThreadState(int value) {
        switch (value) {
            case 0: {
                return ThreadState.RUNNING;
            }
            case 1: {
                return ThreadState.SUSPENDED;
            }
        }
        throw new IllegalArgumentException(String.format("Received invalid thread state %d", value));
    }

    @Override
    protected ThreadCreatedReply parseError(int packetId) {
        throw new IllegalStateException("IE01092: Received invalid reply from the debug client");
    }

    @Override
    public ThreadCreatedReply parseSuccess(int packetId, int argumentCount) throws IOException {
        long thread_id = this.parseThreadId();
        ThreadState threadState = this.convertThreadState(this.parseInteger());
        return new ThreadCreatedReply(packetId, 0, thread_id, threadState);
    }
}

