/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.parsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MessageParserException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterDescription;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TargetInformationParser {
    private TargetInformationParser() {
    }

    private static String getAttribute(Node node, String attribute) throws MessageParserException {
        Node attributeNode = node.getAttributes().getNamedItem(attribute);
        if (attributeNode == null) {
            throw new MessageParserException(String.format("%s message does not have a '%s' attribute", node.getNodeName(), attribute));
        }
        return attributeNode.getNodeValue();
    }

    private static DebuggerOptions parseOptionsInformation(Node node) throws MessageParserException {
        NodeList nodes = node.getChildNodes();
        DebuggerOptions.DebuggerOptionsBuilder builder = new DebuggerOptions.DebuggerOptionsBuilder();
        block18: for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node child = nodes.item(i2);
            String name = TargetInformationParser.getAttribute(child, "name");
            switch (TargetInformationDebuggerOptions.getEnum(name)) {
                case CAN_DETACH: {
                    builder.canDetach(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_ATTACH: {
                    builder.canAttach(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_TERMINATE: {
                    builder.canTerminate(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case HAS_STACK: {
                    builder.stackAvailable(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_VALIDATE_MEMORY: {
                    builder.canValidateMemory(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_HALT: {
                    builder.canHalt(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_HALT_BEFORE_COMMUNICATING: {
                    builder.canHaltBeforeCommunicating(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_MULTI_THREAD: {
                    builder.canMultithread(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_SOFTWARE_BREAKPOINTS: {
                    builder.canSoftwareBreakpoints(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case BREAKPOINT_COUNT: {
                    builder.breakpointCounter(TargetInformationParser.parseIntOption(child, "value"));
                    continue block18;
                }
                case PAGE_SIZE: {
                    builder.pageSize(TargetInformationParser.parseIntOption(child, "value"));
                    continue block18;
                }
                case CAN_BREAK_ON_MODULE_LOAD: {
                    builder.canBreakOnModuleLoad(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_BREAK_ON_MODULE_UNLOAD: {
                    builder.canBreakOnModuleUnload(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case EXCEPTION: {
                    builder.addException(TargetInformationParser.parseExceptionOption(child));
                    continue block18;
                }
                case CAN_TRACE_COUNT: {
                    builder.canTraceCounts(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                case CAN_MEMMAP: {
                    builder.canMemmap(TargetInformationParser.parseBooleanOption(child));
                    continue block18;
                }
                default: {
                    throw new MessageParserException(String.format("Invalid attribute '%s' found in debugger options string", name));
                }
            }
        }
        return builder.build();
    }

    private static boolean parseBooleanOption(Node node) {
        return Boolean.valueOf(node.getAttributes().getNamedItem("value").getNodeValue());
    }

    private static long parseLongOption(Node node, String itemName) {
        return Long.valueOf(node.getAttributes().getNamedItem(itemName).getNodeValue());
    }

    private static int parseIntOption(Node node, String itemName) {
        return Integer.valueOf(node.getAttributes().getNamedItem(itemName).getNodeValue());
    }

    private static String parseStringOption(Node node, String itemName) {
        return node.getAttributes().getNamedItem(itemName).getNodeValue();
    }

    private static DebuggerException parseExceptionOption(Node node) {
        return new DebuggerException(TargetInformationParser.parseStringOption(node, "exceptionName"), TargetInformationParser.parseLongOption(node, "exceptionCode"), DebuggerExceptionHandlingAction.convertToHandlingAction(TargetInformationParser.parseIntOption(node, "handlingAction")));
    }

    private static List<RegisterDescription> parseRegisterInformation(Node node) throws MessageParserException {
        ArrayList<RegisterDescription> registers = new ArrayList<RegisterDescription>();
        NodeList nodes = node.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node child = nodes.item(i2);
            String registerName = TargetInformationParser.getAttribute(child, "name");
            String registerSize = TargetInformationParser.getAttribute(child, "size");
            String registerEditable = TargetInformationParser.getAttribute(child, "editable");
            registers.add(new RegisterDescription(registerName, Integer.valueOf(registerSize), Boolean.valueOf(registerEditable)));
        }
        return registers;
    }

    public static TargetInformation parse(byte[] data) throws MessageParserException {
        Preconditions.checkNotNull(data, "IE01300: Data argument can not be null");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        int addressSize = -1;
        List<RegisterDescription> registers = null;
        DebuggerOptions options = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            NodeList nodes = document.getFirstChild().getChildNodes();
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node node = nodes.item(i2);
                String nodeName = node.getNodeName();
                if ("registers".equals(nodeName)) {
                    registers = TargetInformationParser.parseRegisterInformation(node);
                    continue;
                }
                if ("size".equals(nodeName)) {
                    addressSize = Integer.valueOf(node.getTextContent());
                    continue;
                }
                if ("options".equals(nodeName)) {
                    options = TargetInformationParser.parseOptionsInformation(node);
                    continue;
                }
                throw new MessageParserException(String.format("Found unknown node '%s' in target information string", nodeName));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            CUtilityFunctions.logException(exception);
            throw new MessageParserException(exception.getLocalizedMessage());
        }
        if (addressSize == -1) {
            throw new MessageParserException("E00070: IE01043: Received invalid target information string (missing address size information)");
        }
        Preconditions.checkNotNull(registers, "IE01044: Received invalid target information string (missing registers information)");
        Preconditions.checkNotNull(options, "IE01046: Received invalid target information string (missing options information)");
        return new TargetInformation(addressSize, registers, options);
    }

    private static enum TargetInformationDebuggerOptions {
        CAN_DETACH("detach"),
        CAN_ATTACH("attach"),
        CAN_TERMINATE("terminate"),
        CAN_HALT("halt"),
        CAN_HALT_BEFORE_COMMUNICATING("haltBeforeCommunicating"),
        PAGE_SIZE("pageSize"),
        CAN_MEMMAP("memmap"),
        HAS_STACK("hasstack"),
        CAN_VALIDATE_MEMORY("validmemory"),
        CAN_MULTI_THREAD("multithread"),
        CAN_SOFTWARE_BREAKPOINTS("softwareBreakpoints"),
        BREAKPOINT_COUNT("breakpointCount"),
        CAN_BREAK_ON_MODULE_LOAD("canBreakOnModuleLoad"),
        CAN_BREAK_ON_MODULE_UNLOAD("canBreakOnModuleUnLoad"),
        CAN_TRACE_COUNT("canTraceCount"),
        EXCEPTION("exception");

        private final String name;

        private TargetInformationDebuggerOptions(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static TargetInformationDebuggerOptions getEnum(String name) {
            for (TargetInformationDebuggerOptions option : TargetInformationDebuggerOptions.values()) {
                if (!option.toString().equalsIgnoreCase(name)) continue;
                return option;
            }
            throw new IllegalArgumentException();
        }
    }
}

