/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.parsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MessageParserException;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MemoryModuleParser {
    private MemoryModuleParser() {
    }

    private static String getAttribute(Node node, String attribute) throws MessageParserException {
        Node attributeNode = node.getAttributes().getNamedItem(attribute);
        if (attributeNode == null) {
            throw new MessageParserException(String.format("IE01038: Module message does not have a '%s' attribute", attribute));
        }
        return attributeNode.getNodeValue();
    }

    public static MemoryModule parseModule(byte[] data) throws MessageParserException {
        Preconditions.checkNotNull(data, "IE01037: Data argument can not be null");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            return MemoryModuleParser.parseModule(document.getFirstChild());
        }
        catch (Exception exception) {
            throw new MessageParserException(exception.getLocalizedMessage());
        }
    }

    public static MemoryModule parseModule(Node node) throws MessageParserException {
        try {
            String name = MemoryModuleParser.getAttribute(node, "name");
            String path = MemoryModuleParser.getAttribute(node, "path");
            RelocatedAddress baseAddress = new RelocatedAddress(new CAddress(new BigInteger(MemoryModuleParser.getAttribute(node, "address"))));
            long size = Long.valueOf(MemoryModuleParser.getAttribute(node, "size"));
            return new MemoryModule(name, path, baseAddress, size);
        }
        catch (Exception exception) {
            throw new MessageParserException(exception.getLocalizedMessage());
        }
    }

    public static TargetProcessThread parseThreadId(byte[] data) throws MessageParserException {
        Preconditions.checkNotNull(data, "IE00057: Data argument can not be null");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            Node node = document.getFirstChild();
            long threadId = Long.valueOf(MemoryModuleParser.getAttribute(node, "threadid"));
            return new TargetProcessThread(threadId, ThreadState.SUSPENDED);
        }
        catch (Exception exception) {
            throw new MessageParserException(exception.getLocalizedMessage());
        }
    }
}

