/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageAddressArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageIntegerArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DebugCommand;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import java.util.Set;

public final class SetBreakpointCommand
extends DebugCommand {
    public SetBreakpointCommand(int packetId, Set<RelocatedAddress> addresses, BreakpointType type) {
        super(SetBreakpointCommand.getCommandForType(type), packetId);
        Preconditions.checkNotNull(addresses, "IE01094: Addresses argument can not be null");
        Preconditions.checkNotNull(type, "IE00959: Type argument can not be null");
        this.addArgument(new DebugMessageIntegerArgument(addresses.size()));
        for (RelocatedAddress address : addresses) {
            this.addArgument(new DebugMessageAddressArgument(address.getAddress()));
        }
    }

    private static int getCommandForType(BreakpointType type) {
        switch (type) {
            case REGULAR: {
                return 1;
            }
            case ECHO: {
                return 2;
            }
            case STEP: {
                return 3;
            }
        }
        throw new IllegalArgumentException(String.format("IE00734: Unknown breakpoint type '%s'", new Object[]{type}));
    }
}

