/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageAddressArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageIntegerArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DebugCommand;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import java.util.Set;

public final class RemoveBreakpointsCommand
extends DebugCommand {
    public RemoveBreakpointsCommand(int packetId, Set<RelocatedAddress> addresses, BreakpointType type) {
        super(RemoveBreakpointsCommand.getCommandForType(type), packetId);
        Preconditions.checkNotNull(addresses, "IE00824: Address argument can not be null");
        this.addArgument(new DebugMessageIntegerArgument(addresses.size()));
        for (RelocatedAddress address : addresses) {
            this.addArgument(new DebugMessageAddressArgument(address.getAddress()));
        }
    }

    private static int getCommandForType(BreakpointType type) {
        Preconditions.checkNotNull(type, "IE01009: Type argument can not be null");
        switch (type) {
            case REGULAR: {
                return 4;
            }
            case ECHO: {
                return 5;
            }
            case STEP: {
                return 6;
            }
        }
        throw new IllegalStateException(String.format("IE00741: Unknown breakpoint type '%s'", new Object[]{type}));
    }
}

