/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.commands;

import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageArgument;
import java.util.ArrayList;
import java.util.List;

public class DebugCommand {
    private final int type;
    private final int packetId;
    private final List<DebugMessageArgument> arguments = new ArrayList<DebugMessageArgument>();

    public DebugCommand(int type, int packetId) {
        this.type = type;
        this.packetId = packetId;
    }

    public final void addArgument(DebugMessageArgument argument) {
        this.arguments.add(argument);
    }

    public final int getPacketId() {
        return this.packetId;
    }

    public final byte[] toByteArray() {
        ArrayList<Byte> argchars = new ArrayList<Byte>();
        argchars.add((byte)(this.type >> 24 & 0xFF));
        argchars.add((byte)(this.type >> 16 & 0xFF));
        argchars.add((byte)(this.type >> 8 & 0xFF));
        argchars.add((byte)(this.type & 0xFF));
        argchars.add((byte)(this.packetId >> 24 & 0xFF));
        argchars.add((byte)(this.packetId >> 16 & 0xFF));
        argchars.add((byte)(this.packetId >> 8 & 0xFF));
        argchars.add((byte)(this.packetId & 0xFF));
        argchars.add((byte)(this.arguments.size() >> 24 & 0xFF));
        argchars.add((byte)(this.arguments.size() >> 16 & 0xFF));
        argchars.add((byte)(this.arguments.size() >> 8 & 0xFF));
        argchars.add((byte)(this.arguments.size() & 0xFF));
        for (DebugMessageArgument argument : this.arguments) {
            argchars.addAll(argument.getBytes());
        }
        byte[] ret = new byte[argchars.size()];
        for (int i2 = 0; i2 < argchars.size(); ++i2) {
            ret[i2] = (Byte)argchars.get(i2);
        }
        return ret;
    }
}

