/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.helpers;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugArgumentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class DebugProtocolHelper {
    private DebugProtocolHelper() {
    }

    private static byte[] readBytes(ClientReader inputStream, int length) throws IOException {
        int retval;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[length];
        for (int read = 0; read < length; read += retval) {
            retval = inputStream.read(data, 0, length - read);
            baos.write(data, 0, retval);
        }
        return baos.toByteArray();
    }

    private static long readDWord(ClientReader inputStream, long expectedValue) throws IOException {
        long value = DebugProtocolHelper.readDWord(inputStream);
        if (value != expectedValue) {
            NaviLogger.severe("Error: Received value does not match expected value", new Object[0]);
        }
        return value;
    }

    public static long readAddress(ClientReader inputStream) throws IOException {
        DebugProtocolHelper.readDWord(inputStream, 8L);
        DebugProtocolHelper.readDWord(inputStream, DebugArgumentType.ADDRESS.getValue());
        long addressHigh32 = DebugProtocolHelper.readDWord(inputStream);
        long addressLow32 = DebugProtocolHelper.readDWord(inputStream);
        long address = (addressLow32 & 0xFFFFFFFFL) + (addressHigh32 << 32 & 0xFFFFFFFF00000000L);
        return address;
    }

    public static byte[] readData(ClientReader inputStream) throws IOException {
        int length = (int)DebugProtocolHelper.readDWord(inputStream);
        DebugProtocolHelper.readDWord(inputStream, DebugArgumentType.DATA.getValue());
        return DebugProtocolHelper.readBytes(inputStream, length);
    }

    public static long readDWord(ClientReader inputStream) throws IOException {
        long readByte = inputStream.read();
        if (readByte == -1L) {
            throw new IOException("End of input stream");
        }
        long dword = (readByte & 0xFFL) << 24 & 0xFFFFFFFFFF000000L;
        readByte = inputStream.read();
        if (readByte == -1L) {
            throw new IOException("End of input stream");
        }
        dword |= (readByte & 0xFFL) << 16 & 0xFF0000L;
        readByte = inputStream.read();
        if (readByte == -1L) {
            throw new IOException("End of input stream");
        }
        dword |= (readByte & 0xFFL) << 8 & 0xFF00L;
        readByte = inputStream.read();
        if (readByte == -1L) {
            throw new IOException("End of input stream");
        }
        return dword |= readByte & 0xFFL & 0xFFL;
    }

    public static long readThreadId(ClientReader inputStream) throws IOException {
        DebugProtocolHelper.readDWord(inputStream, 4L);
        DebugProtocolHelper.readDWord(inputStream, DebugArgumentType.INTEGER.getValue());
        return DebugProtocolHelper.readDWord(inputStream);
    }
}

