/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.DebugEventListener;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.concurrent.LinkedBlockingQueue;

public final class PipeFetcher
implements Runnable {
    private final LinkedBlockingQueue<DebuggerReply> eventQueue;
    private final ListenerProvider<DebugEventListener> listeners = new ListenerProvider();
    private boolean m_run = true;
    private final ListenerProvider<DebugEventListener> protocolListeners = new ListenerProvider();

    public PipeFetcher(LinkedBlockingQueue<DebuggerReply> eventQueue) {
        this.eventQueue = Preconditions.checkNotNull(eventQueue, "IE00742: Event queue can't be null");
    }

    private void notifyEventListeners(DebuggerReply event) {
        for (DebugEventListener listener : this.listeners) {
            try {
                listener.receivedEvent(event);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        for (DebugEventListener listener : this.protocolListeners) {
            try {
                listener.receivedEvent(event);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addEventListener(DebugEventListener listener) {
        this.listeners.addListener(listener);
    }

    public void addProtocolEventListener(DebugEventListener listener) {
        this.protocolListeners.addListener(listener);
    }

    public void removeEventListener(DebugEventListener listener) {
        this.listeners.removeListener(listener);
    }

    public void removeProtocolEventListener(DebugEventListener listener) {
        this.protocolListeners.removeListener(listener);
    }

    public void reset() {
        this.m_run = true;
    }

    @Override
    public void run() {
        while (this.m_run) {
            try {
                this.notifyEventListeners(this.eventQueue.take());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void shutdown() {
        this.m_run = false;
    }
}

