/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.PipeFetcher;
import com.google.security.zynamics.binnavi.debug.connection.ReceiveWorker;
import com.google.security.zynamics.binnavi.debug.connection.helpers.PacketIdGenerator;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.DebugConnection;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.DebugEventListener;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.CancelTargetSelectionCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DebugCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DetachCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.HaltCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.MemoryRangeCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RemoveBreakpointsCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestFilesCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestFilesPathCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestMemoryCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestMemoryMapCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestProcessesCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.RequestRegistersCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.ResumeCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.ResumeThreadCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SearchCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SelectFileCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SelectProcessCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SetBreakpointCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SetBreakpointConditionCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SetDebuggerEventSettingsCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SetExceptionSettingsCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SetRegisterCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SingleStepCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.SuspendThreadCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.TerminateCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.WriteMemoryCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractConnection
implements DebugConnection {
    private static final PacketIdGenerator packetIdGenerator = new PacketIdGenerator();
    private ReceiveWorker receiverThread = null;
    private final PipeFetcher pipeFetcherThread;
    private final LinkedBlockingQueue<DebuggerReply> eventQueue = new LinkedBlockingQueue();
    private Thread fetcherThread;
    private Thread workerThread;

    public AbstractConnection() {
        this.pipeFetcherThread = new PipeFetcher(this.eventQueue);
    }

    private static int getMessageId() {
        return packetIdGenerator.next();
    }

    protected abstract int sendPacket(DebugCommand var1) throws IOException;

    protected void startConnection(ClientReader reader) {
        NaviLogger.info("Starting the connection to the debug client", new Object[0]);
        Preconditions.checkNotNull(reader, "IE00738: Reader can not be null");
        String string2 = String.valueOf(Thread.currentThread().getStackTrace()[6]);
        this.fetcherThread = new Thread((Runnable)this.pipeFetcherThread, new StringBuilder(15 + String.valueOf(string2).length()).append("Pipe Fetcher (").append(string2).append(")").toString());
        this.pipeFetcherThread.reset();
        this.fetcherThread.start();
        this.receiverThread = new ReceiveWorker(reader, this.eventQueue);
        this.workerThread = new Thread((Runnable)this.receiverThread, "Receive Worker");
        this.workerThread.start();
    }

    @Override
    public void addEventListener(DebugEventListener listener) {
        this.pipeFetcherThread.addEventListener(listener);
    }

    public void addProtocolEventListener(DebugEventListener listener) {
        this.pipeFetcherThread.addProtocolEventListener(listener);
    }

    @Override
    public void removeEventListener(DebugEventListener listener) {
        this.pipeFetcherThread.removeEventListener(listener);
    }

    public void removeProtocolEventListener(DebugEventListener listener) {
        this.pipeFetcherThread.removeProtocolEventListener(listener);
    }

    @Override
    public int sendBreakpointsMessage(Set<RelocatedAddress> addresses, BreakpointType type) throws IOException {
        Preconditions.checkArgument(addresses.size() != 0, "ERROR: addresses can not be empty");
        NaviLogger.info("Sending \"Set Breakpoint\" message to the debug client", new Object[0]);
        return this.sendPacket(new SetBreakpointCommand(AbstractConnection.getMessageId(), addresses, type));
    }

    @Override
    public int sendCancelTargetSelection() throws IOException {
        NaviLogger.info("Sending \"Cancel Target Selection\" message to the debug client", new Object[0]);
        return this.sendPacket(new CancelTargetSelectionCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendDebuggerEventSettingsMessage(DebuggerEventSettings eventSettings) throws IOException {
        NaviLogger.info("Sending \"Set Debugger Event Settings\" message to the debug client", new Object[0]);
        return this.sendPacket(new SetDebuggerEventSettingsCommand(AbstractConnection.getMessageId(), eventSettings));
    }

    @Override
    public int sendDetachMessage() throws IOException {
        NaviLogger.info("Sending \"Detach\" message to the debug client", new Object[0]);
        return this.sendPacket(new DetachCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendExceptionSettingsMessage(Collection<DebuggerException> exceptions2) throws IOException {
        NaviLogger.info("Sending \"Exception Settings\" message to the debug client", new Object[0]);
        return this.sendPacket(new SetExceptionSettingsCommand(AbstractConnection.getMessageId(), exceptions2));
    }

    @Override
    public int sendHaltMessage() throws IOException {
        NaviLogger.info("Sending \"Halt\" message to the debug client", new Object[0]);
        return this.sendPacket(new HaltCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public void sendMemoryMapMessage() throws IOException {
        NaviLogger.info("Sending \"Memory Map\" message to the debug client", new Object[0]);
        this.sendPacket(new RequestMemoryMapCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendMemoryRangeMessage(IAddress address) throws IOException {
        NaviLogger.info("Sending \"Memory Range\" message to the debug client", new Object[0]);
        return this.sendPacket(new MemoryRangeCommand(AbstractConnection.getMessageId(), address));
    }

    @Override
    public int sendReadMemoryMessage(IAddress address, int length) throws IOException {
        NaviLogger.info(String.format("Sending \"Read Memory %s/%X\" message to the debug client", address.toHexString(), length), new Object[0]);
        return this.sendPacket(new RequestMemoryCommand(AbstractConnection.getMessageId(), address, new CAddress(length)));
    }

    @Override
    public int sendRegisterRequestMessage() throws IOException {
        NaviLogger.info("Sending \"Get Registers\" message to the debug client", new Object[0]);
        return this.sendPacket(new RequestRegistersCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendRemoveBreakpointsMessage(Set<RelocatedAddress> addresses, BreakpointType type) throws IOException {
        NaviLogger.info("Sending \"Remove Breakpoint\" message to the debug client", new Object[0]);
        return this.sendPacket(new RemoveBreakpointsCommand(AbstractConnection.getMessageId(), addresses, type));
    }

    @Override
    public int sendRequestFileSystem() throws IOException {
        NaviLogger.info("Sending \"Request File System\" message to the debug client", new Object[0]);
        return this.sendPacket(new RequestFilesCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public void sendRequestFileSystem(String path) throws IOException {
        NaviLogger.info("Sending \"Request File System + Path\" message to the debug client", new Object[0]);
        this.sendPacket(new RequestFilesPathCommand(AbstractConnection.getMessageId(), path));
    }

    @Override
    public int sendRequestProcessList() throws IOException {
        NaviLogger.info("Sending \"Request Process List\" message to the debug client", new Object[0]);
        return this.sendPacket(new RequestProcessesCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendResumeMessage() throws IOException {
        NaviLogger.info("Sending \"Resume\" message to the debug client", new Object[0]);
        return this.sendPacket(new ResumeCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendResumeThreadMessage(long tid) throws IOException {
        NaviLogger.info("Sending \"Resume Thread\" message to the debug client", new Object[0]);
        return this.sendPacket(new ResumeThreadCommand(AbstractConnection.getMessageId(), tid));
    }

    @Override
    public int sendSearchMessage(IAddress start, int size, byte[] data) throws IOException {
        NaviLogger.info("Sending \"Search Memory\" message to the debug client", new Object[0]);
        return this.sendPacket(new SearchCommand(AbstractConnection.getMessageId(), start, new CAddress(size), data));
    }

    @Override
    public void sendSelectFileMessage(String name) throws IOException {
        NaviLogger.info("Sending \"Select File\" message to the debug client", new Object[0]);
        this.sendPacket(new SelectFileCommand(AbstractConnection.getMessageId(), name));
    }

    @Override
    public int sendSelectProcessMessage(int pid) throws IOException {
        NaviLogger.info("Sending \"Select Process\" message to the debug client", new Object[0]);
        return this.sendPacket(new SelectProcessCommand(AbstractConnection.getMessageId(), pid));
    }

    @Override
    public int sendSetBreakpointConditionMessage(RelocatedAddress address, Condition condition) throws IOException {
        NaviLogger.info("Sending \"Set Breakpoint Condition\" message to the debug client", new Object[0]);
        return this.sendPacket(new SetBreakpointConditionCommand(AbstractConnection.getMessageId(), address, condition));
    }

    @Override
    public int sendSetRegisterMessage(long tid, int index, BigInteger value) throws IOException {
        NaviLogger.info("Sending \"Set Register\" message to the debug client", new Object[0]);
        return this.sendPacket(new SetRegisterCommand(AbstractConnection.getMessageId(), tid, index, new CAddress(value)));
    }

    @Override
    public int sendSingleStepMessage() throws IOException {
        NaviLogger.info("Sending \"Single Step\" message to the debug client", new Object[0]);
        return this.sendPacket(new SingleStepCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendSuspendThreadMessage(long tid) throws IOException {
        NaviLogger.info("Sending \"Suspend Thread\" message to the debug client", new Object[0]);
        return this.sendPacket(new SuspendThreadCommand(AbstractConnection.getMessageId(), tid));
    }

    @Override
    public int sendTerminateMessage() throws IOException {
        NaviLogger.info("Sending \"Terminate\" message to the debug client", new Object[0]);
        return this.sendPacket(new TerminateCommand(AbstractConnection.getMessageId()));
    }

    @Override
    public int sendWriteMemoryMessage(IAddress address, byte[] data) throws IOException {
        NaviLogger.info("Sending \"Write Memory\" message to the debug client", new Object[0]);
        return this.sendPacket(new WriteMemoryCommand(AbstractConnection.getMessageId(), address, data));
    }

    @Override
    public void shutdown() {
        NaviLogger.info("Shutting down the connection to the debug client", new Object[0]);
        if (this.receiverThread != null) {
            this.receiverThread.shutdown();
            this.workerThread.interrupt();
        }
        if (this.pipeFetcherThread != null) {
            this.pipeFetcherThread.shutdown();
            this.fetcherThread.interrupt();
        }
    }
}

