/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.config;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.CallGraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.config.ColorsConfigItem;
import com.google.security.zynamics.binnavi.config.DatabaseConfigItem;
import com.google.security.zynamics.binnavi.config.DebugColorsConfigItem;
import com.google.security.zynamics.binnavi.config.FileReadException;
import com.google.security.zynamics.binnavi.config.FileWriteException;
import com.google.security.zynamics.binnavi.config.FlowGraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.common.config.ConfigHelper;
import com.google.security.zynamics.common.config.TypedPropertiesWrapper;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;

public final class ConfigManager {
    private static final String DATABASES_PREFIX = "Databases.";
    private static final String DATABASES_COUNT = "Databases.Count";
    private static final int DATABASES_COUNT_DEFAULT = 0;
    private static final ConfigManager instance = new ConfigManager(ConfigHelper.getConfigFileName("zynamics", "BinNavi", "config.xml"));
    private final TypedPropertiesWrapper properties;
    private final List<DatabaseConfigItem> databases;
    private final GeneralSettingsConfigItem generalSettings;
    private final ColorsConfigItem colors;
    private final DebugColorsConfigItem debuggerColors;
    private final CallGraphSettingsConfigItem callGraphSettings;
    private final FlowGraphSettingsConfigItem flowGraphSettings;
    private final String filename;

    private ConfigManager(String filename) {
        this.filename = filename;
        this.properties = new TypedPropertiesWrapper(new Properties());
        this.databases = Lists.newArrayList();
        this.generalSettings = new GeneralSettingsConfigItem();
        this.colors = new ColorsConfigItem();
        this.debuggerColors = new DebugColorsConfigItem();
        this.callGraphSettings = new CallGraphSettingsConfigItem();
        this.flowGraphSettings = new FlowGraphSettingsConfigItem();
    }

    private static void updateGraphSettings(GraphSettingsConfigItem graphSettings, ZyGraphViewSettings settings) {
        graphSettings.setAutomaticLayouting(settings.getLayoutSettings().getAutomaticLayouting());
        graphSettings.setProximityBrowsing(settings.getProximitySettings().getProximityBrowsing());
        graphSettings.setProximityBrowsingThreshold(settings.getProximitySettings().getProximityBrowsingActivationThreshold());
        graphSettings.setAutoLayoutDeactivationThreshold(settings.getLayoutSettings().getAutolayoutDeactivationThreshold());
        graphSettings.setLayoutCalculationThreshold(settings.getLayoutSettings().getLayoutCalculationTimeWarningThreshold());
        graphSettings.setVisibilityWarningThreshold(settings.getLayoutSettings().getVisibilityWarningTreshold());
        graphSettings.setHierarchicMinimumLayerDistance(settings.getLayoutSettings().getHierarchicalSettings().getMinimumLayerDistance());
        graphSettings.setHierarchicMinimumNodeDistance(settings.getLayoutSettings().getHierarchicalSettings().getMinimumNodeDistance());
        graphSettings.setHierarchicMinimumEdgeDistance(settings.getLayoutSettings().getHierarchicalSettings().getMinimumEdgeDistance());
        graphSettings.setHierarchicEdgeRoutingStyle(settings.getLayoutSettings().getHierarchicalSettings().getStyle().ordinal());
        graphSettings.setHierarchicOrientation(settings.getLayoutSettings().getHierarchicalSettings().getOrientation().ordinal());
        graphSettings.setOrthogonalMinimumNodeDistance(settings.getLayoutSettings().getOrthogonalSettings().getMinimumNodeDistance());
        graphSettings.setOrthogonalLayoutStyle(settings.getLayoutSettings().getOrthogonalSettings().getStyle().ordinal());
        graphSettings.setOrthogonalOrientation(settings.getLayoutSettings().getOrthogonalSettings().getOrientation().ordinal());
        graphSettings.setCircularMinimumNodeDistance(settings.getLayoutSettings().getCircularSettings().getMinimumNodeDistance());
        graphSettings.setCircularLayoutStyle(settings.getLayoutSettings().getCircularSettings().getStyle().ordinal());
        graphSettings.setDefaultGraphLayout(settings.getLayoutSettings().getDefaultGraphLayout().ordinal());
        graphSettings.setScrollSensitivity(settings.getMouseSettings().getScrollSensitivity());
        graphSettings.setZoomSensitivity(settings.getMouseSettings().getZoomSensitivity());
        graphSettings.setLayoutAnimation(settings.getLayoutSettings().getAnimateLayout());
        graphSettings.setAnimationSpeed(settings.getDisplaySettings().getAnimationSpeed());
        graphSettings.setGradientBackground(settings.getDisplaySettings().getGradientBackground());
        graphSettings.setFunctionNodeInformation(settings.getDisplaySettings().getFunctionNodeInformation());
        graphSettings.setAnimationSpeed(settings.getDisplaySettings().getAnimationSpeed());
        graphSettings.setMouseWheelAction(settings.getMouseSettings().getMouseWheelAction().ordinal());
        graphSettings.setProximityBrowsingChildren(settings.getProximitySettings().getProximityBrowsingChildren());
        graphSettings.setProximityBrowsingParents(settings.getProximitySettings().getProximityBrowsingParents());
        graphSettings.setEdgeHidingMode(settings.getEdgeSettings().getEdgeHidingMode().ordinal());
        graphSettings.setEdgeHidingThreshold(settings.getEdgeSettings().getEdgeHidingThreshold());
        graphSettings.setDrawBends(settings.getEdgeSettings().getDrawSelectedBends());
    }

    public static ConfigManager instance() {
        return instance;
    }

    public List<DatabaseConfigItem> getDatabases() {
        return this.databases;
    }

    public GeneralSettingsConfigItem getGeneralSettings() {
        return this.generalSettings;
    }

    public ColorsConfigItem getColorSettings() {
        return this.colors;
    }

    public DebugColorsConfigItem getDebuggerColorSettings() {
        return this.debuggerColors;
    }

    public ZyGraphViewSettings getDefaultCallGraphSettings() {
        return new ZyGraphViewSettings(new ZyGraphViewSettings(this.callGraphSettings));
    }

    public ZyGraphViewSettings getDefaultFlowGraphSettings() {
        return new ZyGraphViewSettings(new ZyGraphViewSettings(this.flowGraphSettings));
    }

    public boolean read() throws FileReadException {
        boolean notFound = false;
        try {
            this.properties.getProperties().loadFromXML(new FileInputStream(this.filename));
        }
        catch (FileNotFoundException e2) {
            notFound = true;
        }
        catch (IOException e3) {
            throw new FileReadException(e3);
        }
        this.generalSettings.load(this.properties);
        int i2 = 0;
        while (i2 < this.properties.getInteger(DATABASES_COUNT, 0)) {
            DatabaseConfigItem database = new DatabaseConfigItem();
            String string2 = String.valueOf(DATABASES_PREFIX);
            int n2 = i2++;
            database.loadWithKeyPrefix(this.properties, new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(".").toString());
            this.databases.add(database);
        }
        this.callGraphSettings.loadWithKeyPrefix(this.properties, "CallGraphSettings.");
        this.flowGraphSettings.loadWithKeyPrefix(this.properties, "FlowGraphSettings.");
        this.colors.loadWithKeyPrefix(this.properties, "Colors.");
        this.debuggerColors.loadWithKeyPrefix(this.properties, "Debugger.Colors.");
        if (notFound) {
            this.flowGraphSettings.setDefaultGraphLayout(1);
            this.flowGraphSettings.setProximityBrowsingThreshold(50);
            this.flowGraphSettings.setAutoLayoutDeactivationThreshold(70);
            this.flowGraphSettings.setLayoutCalculationThreshold(250);
            return false;
        }
        return true;
    }

    private void write() throws FileWriteException {
        this.generalSettings.store(this.properties);
        this.properties.setInteger(DATABASES_COUNT, this.databases.size());
        for (int i2 = 0; i2 < this.databases.size(); ++i2) {
            String string2 = String.valueOf(DATABASES_PREFIX);
            int n2 = i2;
            this.databases.get(i2).storeWithKeyPrefix(this.properties, new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(".").toString());
        }
        this.callGraphSettings.storeWithKeyPrefix(this.properties, "CallGraphSettings.");
        this.flowGraphSettings.storeWithKeyPrefix(this.properties, "FlowGraphSettings.");
        this.colors.storeWithKeyPrefix(this.properties, "Colors.");
        this.debuggerColors.storeWithKeyPrefix(this.properties, "Debugger.Colors.");
        try {
            File configDir = new File(this.filename).getParentFile();
            if (configDir != null) {
                configDir.mkdirs();
            }
            this.properties.getProperties().storeToXML(new FileOutputStream(this.filename), "BinNavi 6.1");
        }
        catch (IOException e2) {
            throw new FileWriteException(e2);
        }
    }

    public void updateCallgraphSettings(ZyGraphViewSettings settings) {
        ConfigManager.updateGraphSettings(this.callGraphSettings, settings);
        this.callGraphSettings.setMultipleEdgesAsOne(settings.getEdgeSettings().getDisplayMultipleEdgesAsOne());
    }

    public void updateFlowgraphSettings(ZyGraphViewSettings settings) {
        ConfigManager.updateGraphSettings(this.flowGraphSettings, settings);
    }

    public void saveSettings(JFrame parent) {
        Point location = parent.getLocation();
        GeneralSettingsConfigItem.LastOpenWindowConfigItem window = this.generalSettings.getLastOpenWindow();
        window.setTop((int)location.getY());
        window.setLeft((int)location.getX());
        window.setHeight(parent.getHeight());
        window.setWidth(parent.getWidth());
        this.generalSettings.setMaximizeWindow(parent.getExtendedState() == 1 || parent.getExtendedState() == 6);
        this.databases.clear();
        for (IDatabase database : CDatabaseManager.instance()) {
            DatabaseConfigItem databaseConfig = new DatabaseConfigItem();
            databaseConfig.setAutoConnect(database.getConfiguration().isAutoConnect());
            databaseConfig.setDescription(database.getConfiguration().getDescription());
            databaseConfig.setDriver(database.getConfiguration().getDriver());
            databaseConfig.setPassword(database.getConfiguration().isSavePassword() ? database.getConfiguration().getPassword() : "");
            databaseConfig.setSavePassword(database.getConfiguration().isSavePassword());
            databaseConfig.setHost(database.getConfiguration().getHost());
            databaseConfig.setName(database.getConfiguration().getName());
            databaseConfig.setUser(database.getConfiguration().getUser());
            databaseConfig.setIdentity(database.getConfiguration().getIdentity());
            this.databases.add(databaseConfig);
        }
        try {
            this.write();
        }
        catch (FileWriteException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00150: Could not write configuration file";
            String innerDescription = CUtilityFunctions.createDescription("The configuration file where the settings are stored could not be written.", new String[]{"There was a problem writing the file. Please see the stacktrace for more information."}, new String[]{"The active configuration was not saved and will be lost."});
            NaviErrorDialog.show(parent, "E00150: Could not write configuration file", innerDescription, e2);
        }
    }
}

