/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphDisplaySettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphEdgeSettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphMouseSettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphProximitySettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphSearchSettings;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Settings.ZyGraphLayoutSettings;
import com.google.security.zynamics.zylib.gui.zygraph.AbstractZyGraphSettings;
import java.util.Map;

public final class ZyGraphViewSettings
extends AbstractZyGraphSettings {
    private final ZyGraphLayoutSettings m_layoutSettings;
    private final ZyGraphProximitySettings m_proximitySettings;
    private final ZyGraphSearchSettings m_searchSettings;
    private final ZyGraphEdgeSettings m_edgeSettings;
    private final ZyGraphDisplaySettings m_displaySettings;
    private final ZyGraphMouseSettings m_mouseSettings;
    public Map<String, String> rawSettings;

    public ZyGraphViewSettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE01527: Type argument can't be null");
        this.m_layoutSettings = new ZyGraphLayoutSettings(type);
        this.m_proximitySettings = new ZyGraphProximitySettings(type);
        this.m_searchSettings = new ZyGraphSearchSettings(type);
        this.m_edgeSettings = new ZyGraphEdgeSettings(type);
        this.m_displaySettings = new ZyGraphDisplaySettings(type);
        this.m_mouseSettings = new ZyGraphMouseSettings(type);
    }

    public ZyGraphViewSettings(ZyGraphViewSettings settings) {
        Preconditions.checkNotNull(settings, "IE00875: Settings argument can't be null");
        this.m_layoutSettings = new ZyGraphLayoutSettings(settings.getLayoutSettings());
        this.m_proximitySettings = new ZyGraphProximitySettings(settings.getProximitySettings());
        this.m_searchSettings = new ZyGraphSearchSettings(settings.getSearchSettings());
        this.m_edgeSettings = new ZyGraphEdgeSettings(settings.getEdgeSettings());
        this.m_displaySettings = new ZyGraphDisplaySettings(settings.getDisplaySettings());
        this.m_mouseSettings = new ZyGraphMouseSettings(settings.getMouseSettings());
    }

    @Override
    public ZyGraphDisplaySettings getDisplaySettings() {
        return this.m_displaySettings;
    }

    public ZyGraphEdgeSettings getEdgeSettings() {
        return this.m_edgeSettings;
    }

    @Override
    public ZyGraphLayoutSettings getLayoutSettings() {
        return this.m_layoutSettings;
    }

    @Override
    public ZyGraphMouseSettings getMouseSettings() {
        return this.m_mouseSettings;
    }

    @Override
    public ZyGraphProximitySettings getProximitySettings() {
        return this.m_proximitySettings;
    }

    public ZyGraphSearchSettings getSearchSettings() {
        return this.m_searchSettings;
    }
}

