/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes;

import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitutionChangedListener;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Set;

public class TypeSubstitutionsUpdater
implements TypeSubstitutionChangedListener {
    private final INaviCodeNode codeNode;
    private final NaviNode naviNode;

    public TypeSubstitutionsUpdater(INaviCodeNode codeNode, NaviNode naviNode) {
        this.codeNode = codeNode;
        this.naviNode = naviNode;
    }

    @Override
    public void substitutionsChanged(Set<TypeSubstitution> changedTypeSubstitutions) {
        this.rebuild(changedTypeSubstitutions);
    }

    @Override
    public void substitutionsDeleted(Set<TypeSubstitution> deletedTypeSubstitutions) {
        this.rebuild(deletedTypeSubstitutions);
    }

    @Override
    public void substitutionsAdded(Set<TypeSubstitution> addedTypeSubstitutions) {
        this.rebuild(addedTypeSubstitutions);
    }

    private void rebuild(Set<TypeSubstitution> typeSubstitutions) {
        IAddress startAddress = this.codeNode.getAddress();
        IAddress endAddress = ((INaviInstruction)this.codeNode.getLastInstruction()).getAddress();
        for (TypeSubstitution substitution : typeSubstitutions) {
            if (substitution.getAddress().toLong() < startAddress.toLong() || substitution.getAddress().toLong() > endAddress.toLong()) continue;
            this.naviNode.getRealizer().regenerate();
            this.naviNode.getRealizer().repaint();
            return;
        }
    }
}

