/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Updaters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CNodeUpdaterFactory;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.INodeUpdater;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class CNodeUpdaterInitializer {
    private CNodeUpdaterInitializer() {
    }

    public static void addUpdaters(final CGraphModel model) {
        Preconditions.checkNotNull(model, "IE02240: Model argument can not be null");
        model.getGraph().iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                CNodeUpdaterInitializer.addUpdaters(model, node);
                return IterationMode.CONTINUE;
            }
        });
    }

    public static void addUpdaters(CGraphModel model, NaviNode node) {
        Preconditions.checkNotNull(model, "IE02236: Model argument can not be null");
        Preconditions.checkNotNull(node, "IE02237: Node argument can not be null");
        for (INodeUpdater updater : CNodeUpdaterFactory.getUpdaters()) {
            updater.visit(model, node);
        }
    }
}

