/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Updaters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyFunctionNodeBuilder;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.disassembly.CFunctionListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.IFunction;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.util.List;

public final class CFunctionNodeUpdater
implements IRealizerUpdater<NaviNode> {
    private final ZyGraph m_graph;
    private final INaviFunctionNode m_node;
    private IZyNodeRealizer m_realizer;
    private final CDefaultModifier m_nodeModifier;
    private final InternalFunctionListener m_functionListener = new InternalFunctionListener();

    public CFunctionNodeUpdater(ZyGraph graph, INaviFunctionNode node, BackEndDebuggerProvider provider) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE00989: Graph argument can't be null");
        this.m_node = Preconditions.checkNotNull(node, "IE00990: Node argument can't be null");
        Preconditions.checkNotNull(provider, "IE02241: Provider argument can not be null");
        this.m_nodeModifier = new CDefaultModifier(graph.getSettings(), provider);
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.m_node.getFunction().addListener(this.m_functionListener);
    }

    private void rebuildNode() {
        this.m_realizer.regenerate();
        this.m_graph.updateViews();
    }

    private void removeListeners() {
        this.m_node.getFunction().removeListener(this.m_functionListener);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    @Override
    public void generateContent(IZyNodeRealizer realizer, ZyLabelContent content) {
        ZyFunctionNodeBuilder.buildContent(content, this.m_node, this.m_graph.getSettings(), this.m_nodeModifier);
    }

    @Override
    public void setRealizer(IZyNodeRealizer realizer) {
        Preconditions.checkNotNull(realizer, "IE00996: Realizer argument can't be null");
        this.m_realizer = realizer;
    }

    private class InternalFunctionListener
    extends CFunctionListenerAdapter {
        private InternalFunctionListener() {
        }

        @Override
        public void appendedComment(IFunction function, IComment comment) {
            if (CFunctionNodeUpdater.this.m_realizer != null) {
                CFunctionNodeUpdater.this.rebuildNode();
            }
        }

        @Override
        public void changedDescription(IFunction function, String description) {
            CFunctionNodeUpdater.this.rebuildNode();
        }

        @Override
        public void changedName(IFunction function, String name) {
            if (CFunctionNodeUpdater.this.m_realizer != null) {
                CFunctionNodeUpdater.this.rebuildNode();
            }
        }

        @Override
        public void deletedComment(IFunction function, IComment comment) {
            if (CFunctionNodeUpdater.this.m_realizer != null) {
                CFunctionNodeUpdater.this.rebuildNode();
            }
        }

        @Override
        public void editedComment(IFunction function, IComment comment) {
            if (CFunctionNodeUpdater.this.m_realizer != null) {
                CFunctionNodeUpdater.this.rebuildNode();
            }
        }

        @Override
        public void initializedComment(IFunction function, List<IComment> comments) {
            if (CFunctionNodeUpdater.this.m_realizer != null) {
                CFunctionNodeUpdater.this.rebuildNode();
            }
        }
    }
}

