/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CEdgeDrawingFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphEdgeSettingsListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.EdgeHidingMode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.settings.CProximitySettingsAdapter;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettingsListener;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class CEdgeDrawingSynchronizer {
    private final ZyGraph m_graph;
    private boolean m_areEdgesVisible;
    private final InternalSettingsListener m_settingsListener = new InternalSettingsListener();
    private final IProximitySettingsListener m_proximityListener = new InternalProximityListener();

    public CEdgeDrawingSynchronizer(ZyGraph graph) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE00980: Graph argument can not be null");
        this.m_areEdgesVisible = CEdgeDrawingFunctions.calcDrawSloppyEdges(this.m_graph);
        this.m_graph.getSettings().getEdgeSettings().addListener(this.m_settingsListener);
        this.m_graph.getSettings().getProximitySettings().addListener(this.m_proximityListener);
    }

    private void setEdgeDrawing(final boolean draw) {
        this.m_graph.iterateEdges(new IEdgeCallback<NaviEdge>(){

            @Override
            public IterationMode nextEdge(NaviEdge edge) {
                edge.setDrawSloppyEdges(draw);
                return IterationMode.CONTINUE;
            }
        });
        this.m_graph.updateViews();
    }

    public void dispose() {
        this.m_graph.getSettings().getEdgeSettings().removeListener(this.m_settingsListener);
        this.m_graph.getSettings().getProximitySettings().removeListener(this.m_proximityListener);
    }

    public void updateEdgeDrawingState() {
        boolean drawEdges;
        if (this.m_graph.getSettings().getEdgeSettings().getEdgeHidingMode() == EdgeHidingMode.HIDE_ON_THRESHOLD && this.m_areEdgesVisible != (drawEdges = CEdgeDrawingFunctions.calcDrawSloppyEdges(this.m_graph))) {
            this.setEdgeDrawing(drawEdges);
            this.m_areEdgesVisible = drawEdges;
        }
    }

    private class InternalSettingsListener
    extends ZyGraphEdgeSettingsListenerAdapter {
        private InternalSettingsListener() {
        }

        @Override
        public void changedEdgeHidingMode(EdgeHidingMode value) {
            CEdgeDrawingSynchronizer.this.setEdgeDrawing(CEdgeDrawingFunctions.calcDrawSloppyEdges(CEdgeDrawingSynchronizer.this.m_graph));
        }

        @Override
        public void changedEdgeHidingThreshold(int threshold) {
            CEdgeDrawingSynchronizer.this.setEdgeDrawing(CEdgeDrawingFunctions.calcDrawSloppyEdges(CEdgeDrawingSynchronizer.this.m_graph));
        }
    }

    private class InternalProximityListener
    extends CProximitySettingsAdapter {
        private InternalProximityListener() {
        }

        @Override
        public void changedProximityBrowsing(boolean value) {
            CEdgeDrawingSynchronizer.this.updateEdgeDrawingState();
        }

        @Override
        public void changedProximityBrowsingPreview(boolean value) {
            CEdgeDrawingSynchronizer.this.updateEdgeDrawingState();
        }
    }
}

