/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphSearchSettingsListener;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ZyGraphSearchSettings {
    private boolean m_searchVisibleNodesOnly;
    private boolean m_searchSelectedNodesOnly;
    private boolean m_searchCaseSensitive;
    private boolean m_searchRegEx;
    private final GraphSettingsConfigItem m_type;
    private final ListenerProvider<IZyGraphSearchSettingsListener> m_listeners = new ListenerProvider();

    public ZyGraphSearchSettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE00873: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphSearchSettings(ZyGraphSearchSettings settings) {
        this.m_type = null;
        this.m_searchCaseSensitive = settings.getSearchCaseSensitive();
        this.m_searchRegEx = settings.getSearchRegEx();
        this.m_searchSelectedNodesOnly = settings.getSearchSelectedNodesOnly();
        this.m_searchVisibleNodesOnly = settings.getSearchVisibleNodesOnly();
    }

    public void addListener(IZyGraphSearchSettingsListener listener) {
        this.m_listeners.addListener(listener);
    }

    public boolean getSearchCaseSensitive() {
        return this.m_type == null ? this.m_searchCaseSensitive : this.m_type.isCaseSensitiveSearch();
    }

    public boolean getSearchRegEx() {
        return this.m_type == null ? this.m_searchRegEx : this.m_type.isRegexSearch();
    }

    public boolean getSearchSelectedNodesOnly() {
        return this.m_type == null ? this.m_searchSelectedNodesOnly : this.m_type.isSearchSelectedNodesOnly();
    }

    public boolean getSearchVisibleNodesOnly() {
        return this.m_type == null ? this.m_searchVisibleNodesOnly : this.m_type.isSearchVisibleNodesOnly();
    }

    public void removeListener(IZyGraphSearchSettingsListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setSearchCaseSensitive(boolean value) {
        if (value == this.getSearchCaseSensitive()) {
            return;
        }
        if (this.m_type == null) {
            this.m_searchCaseSensitive = value;
        } else {
            this.m_type.setCaseSensitiveSearch(value);
        }
        for (IZyGraphSearchSettingsListener listener : this.m_listeners) {
            try {
                listener.changedSearchCaseSensitive(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setSearchRegEx(boolean value) {
        if (value == this.getSearchRegEx()) {
            return;
        }
        if (this.m_type == null) {
            this.m_searchRegEx = value;
        } else {
            this.m_type.setRegexSearch(value);
        }
        for (IZyGraphSearchSettingsListener listener : this.m_listeners) {
            try {
                listener.changedSearchRegEx(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setSearchSelectedNodesOnly(boolean value) {
        if (value == this.getSearchSelectedNodesOnly()) {
            return;
        }
        if (this.m_type == null) {
            this.m_searchSelectedNodesOnly = value;
        } else {
            this.m_type.setSearchSelectedNodesOnly(value);
        }
        for (IZyGraphSearchSettingsListener listener : this.m_listeners) {
            try {
                listener.changedSearchSelectionNodesOnly(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setSearchVisibleNodesOnly(boolean value) {
        if (value == this.getSearchVisibleNodesOnly()) {
            return;
        }
        if (this.m_type == null) {
            this.m_searchVisibleNodesOnly = value;
        } else {
            this.m_type.setSearchVisibleNodesOnly(value);
        }
        for (IZyGraphSearchSettingsListener listener : this.m_listeners) {
            try {
                listener.changedSearchVisibleNodesOnly(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

