/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalStyle;

public final class ZyGraphOrthogonalSettings {
    private OrthogonalOrientation m_orientation;
    private OrthogonalStyle m_style;
    private int m_mininmumNodeDistance;
    private final GraphSettingsConfigItem m_type;

    public ZyGraphOrthogonalSettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE02026: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphOrthogonalSettings(ZyGraphOrthogonalSettings settings) {
        this.m_type = null;
        this.m_mininmumNodeDistance = settings.getMinimumNodeDistance();
        this.m_orientation = settings.getOrientation();
        this.m_style = settings.getStyle();
    }

    private static OrthogonalOrientation getOrthogonalOrientation(GraphSettingsConfigItem type) {
        try {
            return OrthogonalOrientation.parseInt(type.getOrthogonalOrientation());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return OrthogonalOrientation.VERTICAL;
        }
    }

    private static OrthogonalStyle getOrthogonalStyle(GraphSettingsConfigItem type) {
        try {
            return OrthogonalStyle.parseInt(type.getOrthogonalLayoutStyle());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return OrthogonalStyle.NORMAL;
        }
    }

    public int getMinimumNodeDistance() {
        return this.m_type == null ? this.m_mininmumNodeDistance : this.m_type.getOrthogonalMinimumNodeDistance();
    }

    public OrthogonalOrientation getOrientation() {
        return this.m_type == null ? this.m_orientation : ZyGraphOrthogonalSettings.getOrthogonalOrientation(this.m_type);
    }

    public OrthogonalStyle getStyle() {
        return this.m_type == null ? this.m_style : ZyGraphOrthogonalSettings.getOrthogonalStyle(this.m_type);
    }

    public void setMinimumNodeDistance(int value) {
        Preconditions.checkArgument(value >= 0, "IE00885: Distance argument must not be negative");
        if (value == this.getMinimumNodeDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_mininmumNodeDistance = value;
        } else {
            this.m_type.setOrthogonalMinimumNodeDistance(value);
        }
    }

    public void setOrientation(OrthogonalOrientation value) {
        Preconditions.checkNotNull(value, "IE00888: Orientation argument must not be negative");
        if (value == this.getOrientation()) {
            return;
        }
        if (this.m_type == null) {
            this.m_orientation = value;
        } else {
            this.m_type.setOrthogonalOrientation(value.ordinal());
        }
    }

    public void setStyle(OrthogonalStyle value) {
        Preconditions.checkNotNull(value, "IE00887: Style argument must not be negative");
        if (value == this.getStyle()) {
            return;
        }
        if (this.m_type == null) {
            this.m_style = value;
        } else {
            this.m_type.setOrthogonalLayoutStyle(value.ordinal());
        }
    }
}

