/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.CircularStyle;

public final class ZyGraphCircularSettings {
    private int m_minimumNodeDistance;
    private CircularStyle m_layout = CircularStyle.COMPACT;
    private final GraphSettingsConfigItem m_type;

    public ZyGraphCircularSettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE02010: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphCircularSettings(ZyGraphCircularSettings settings) {
        this.m_type = null;
        this.m_layout = settings.getStyle();
        this.m_minimumNodeDistance = settings.getMinimumNodeDistance();
    }

    private static CircularStyle getCircularLayoutStyle(GraphSettingsConfigItem type) {
        try {
            return CircularStyle.parseInt(type.getCircularLayoutStyle());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return CircularStyle.COMPACT;
        }
    }

    public int getMinimumNodeDistance() {
        return this.m_type == null ? this.m_minimumNodeDistance : this.m_type.getCircularMinimumNodeDistance();
    }

    public CircularStyle getStyle() {
        return this.m_type == null ? this.m_layout : ZyGraphCircularSettings.getCircularLayoutStyle(this.m_type);
    }

    public void setMinimumNodeDistance(int value) {
        Preconditions.checkArgument(value >= 0, "IE00881: Distance argument must not be negative");
        if (value == this.getMinimumNodeDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_minimumNodeDistance = value;
        } else {
            this.m_type.setCircularMinimumNodeDistance(value);
        }
    }

    public void setStyle(CircularStyle value) {
        Preconditions.checkNotNull(value, "IE00902: Style argument can't be null");
        if (value == this.getStyle()) {
            return;
        }
        if (this.m_type == null) {
            this.m_layout = value;
        } else {
            this.m_type.setCircularLayoutStyle(value.ordinal());
        }
    }
}

