/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CContentSelectionMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CFunctionNodeMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CGroupNodeMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CTextNodeMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CCodeNodeMenu;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import java.util.List;
import javax.swing.JPopupMenu;

public final class ZyGraphPopupMenus {
    private ZyGraphPopupMenus() {
    }

    private static JPopupMenu getNodePopup(CGraphModel model, NaviNode node, Object clickedObject, double y2, boolean contentSelectionActive, List<ICodeNodeExtension> extensions) {
        Preconditions.checkNotNull(node, "IE00976: Node argument can't be null");
        if (contentSelectionActive) {
            return new CContentSelectionMenu(model, node);
        }
        INaviViewNode rawNode = node.getRawNode();
        if (rawNode instanceof CFunctionNode) {
            return new CFunctionNodeMenu(model, node, y2);
        }
        if (rawNode instanceof CCodeNode) {
            return new CCodeNodeMenu(model, node, clickedObject, y2, extensions);
        }
        if (rawNode instanceof CTextNode) {
            return new CTextNodeMenu(model.getParent(), model.getGraph().getRawView(), (CTextNode)rawNode);
        }
        if (rawNode instanceof CGroupNode) {
            return new CGroupNodeMenu(model.getParent(), model.getGraph().getRawView(), (CGroupNode)rawNode);
        }
        throw new IllegalStateException("IE00977: Unknown node type");
    }

    public static JPopupMenu getPopupMenu(CGraphModel model, NaviNode node, Object clickedObject, double y2, boolean contentSelectionActive, List<ICodeNodeExtension> extensions) {
        return ZyGraphPopupMenus.getNodePopup(model, node, clickedObject, y2, contentSelectionActive, extensions);
    }
}

