/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyInstructionBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionDeleteInstruction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionShowReilCode;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionSplitAfter;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionToggleBreakpoint;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionToggleBreakpointStatus;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.COperandsMenu;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import java.util.List;
import javax.swing.JMenu;

public final class CInstructionMenu
extends JMenu {
    private static final long serialVersionUID = 1467406495056009235L;

    public CInstructionMenu(CGraphModel model, NaviNode node, INaviInstruction instruction, List<ICodeNodeExtension> extensions) {
        String string2 = String.valueOf("Instruction ");
        String string3 = String.valueOf(ZyInstructionBuilder.buildInstructionLine(instruction, model.getGraph().getSettings(), new CDefaultModifier(model.getGraph().getSettings(), model.getDebuggerProvider())).first());
        super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
        IDebugger debugger = CGraphDebugger.getDebugger(model.getDebuggerProvider(), instruction);
        if (debugger != null) {
            INaviModule module = instruction.getModule();
            UnrelocatedAddress instructionAddress = new UnrelocatedAddress(instruction.getAddress());
            this.add(CActionProxy.proxy(new CActionToggleBreakpoint(debugger.getBreakpointManager(), module, instructionAddress)));
            BreakpointAddress relocatedAddress = new BreakpointAddress(module, instructionAddress);
            if (debugger.getBreakpointManager().hasBreakpoint(BreakpointType.REGULAR, relocatedAddress)) {
                this.add(CActionProxy.proxy(new CActionToggleBreakpointStatus(debugger.getBreakpointManager(), module, instructionAddress)));
            }
            this.addSeparator();
        }
        for (ICodeNodeExtension extension2 : extensions) {
            extension2.extendInstruction(this, codeNode, instruction);
        }
        try {
            try {
                COperandsMenu operandsMenu = new COperandsMenu(codeNode, instruction, extensions);
                if (operandsMenu.getItemCount() != 0) {
                    this.add(operandsMenu);
                }
            }
            catch (MaybeNullException operandsMenu) {}
        }
        catch (InternalTranslationException e2) {
            CUtilityFunctions.logException(e2);
        }
        this.addSeparator();
        JMenu advancedMenu = new JMenu("Advanced");
        advancedMenu.add(CActionProxy.proxy(new CActionDeleteInstruction(model.getParent(), model.getGraph(), node, instruction)));
        advancedMenu.add(CActionProxy.proxy(new CActionSplitAfter(model.getGraph().getRawView(), codeNode, instruction)));
        advancedMenu.add(CActionProxy.proxy(new CActionShowReilCode(model.getParent(), instruction)));
        this.add(advancedMenu);
    }
}

