/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus;

import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionToggleBreakpoint;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionToggleBreakpointStatus;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CChangeFunctionNameAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CCopyLineAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CCopyNodeAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CFunctionNodeInlineAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.COpenFunctionAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CMenuBuilder;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class CFunctionNodeMenu
extends JPopupMenu {
    private static final long serialVersionUID = 2340597335457814902L;

    public CFunctionNodeMenu(CGraphModel model, NaviNode node, double y2) {
        INaviFunctionNode functionNode = (INaviFunctionNode)node.getRawNode();
        int line = node.positionToRow(y2);
        this.add(new CChangeFunctionNameAction(model.getParent(), functionNode.getFunction().getModule().getContent().getViewContainer().getView(functionNode.getFunction())));
        CMenuBuilder.addCommentMenu(this, model, node.getRawNode());
        CMenuBuilder.addSelectionMenus(this, model.getGraph(), node);
        if (functionNode.getFunction().getBasicBlockCount() != 0) {
            this.add(new JMenuItem(CActionProxy.proxy(new COpenFunctionAction(model.getParent(), model.getViewContainer(), functionNode.getFunction()))));
            this.add(new JMenuItem(CActionProxy.proxy(new CFunctionNodeInlineAction(model.getParent(), model.getGraph(), functionNode))));
            this.addSeparator();
        }
        CMenuBuilder.addTaggingMenu(this, model, node);
        JMenu clipMenu = new JMenu("Clipboard");
        clipMenu.add(CActionProxy.proxy(new CCopyLineAction(node, line)));
        clipMenu.add(CActionProxy.proxy(new CCopyNodeAction(node)));
        this.add(clipMenu);
        IDebugger debugger = CGraphDebugger.getDebugger(model.getDebuggerProvider(), functionNode);
        if (debugger == null) {
            return;
        }
        this.addSeparator();
        String string2 = String.valueOf("Function ");
        String string3 = String.valueOf(functionNode.getFunction().getName());
        JMenu functionMenu = new JMenu(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        UnrelocatedAddress address = new UnrelocatedAddress(functionNode.getFunction().getAddress());
        INaviModule module = functionNode.getFunction().getModule();
        functionMenu.add(CActionProxy.proxy(new CActionToggleBreakpoint(debugger.getBreakpointManager(), module, address)));
        BreakpointAddress relocatedAddress = new BreakpointAddress(module, address);
        if (debugger.getBreakpointManager().hasBreakpoint(BreakpointType.REGULAR, relocatedAddress)) {
            functionMenu.add(CActionProxy.proxy(new CActionToggleBreakpointStatus(debugger.getBreakpointManager(), module, address)));
        }
        this.add(functionMenu);
    }
}

