/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CUnInliner;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class CUnInlineAction
extends AbstractAction {
    private static final long serialVersionUID = -5262453620487375988L;
    private final JFrame m_parent;
    private final ZyGraph m_graph;
    private final INaviCodeNode m_node;

    public CUnInlineAction(JFrame parent, ZyGraph graph, INaviCodeNode node) {
        super(String.format("Uninline '%s'", CUnInlineAction.getParentFunction(node)));
        this.m_parent = Preconditions.checkNotNull(parent, "IE02365: parent argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE02366: graph argument can not be null");
        this.m_node = Preconditions.checkNotNull(node, "IE02367: node argument can not be null");
    }

    private static String getParentFunction(INaviCodeNode node) {
        try {
            return node.getParentFunction().getName();
        }
        catch (MaybeNullException exception) {
            return "";
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CUnInliner.unInline(this.m_parent, this.m_graph, this.m_node);
    }
}

