/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;

class InternalNodeCallBack
implements INodeCallback<NaviNode> {
    private boolean nodeFound = false;
    private final INaviModule module;
    private final ZyGraph graph;
    private final IAddress address;
    private final boolean animate;

    public InternalNodeCallBack(INaviModule module, ZyGraph graph, IAddress address, boolean animate) {
        this.module = module;
        this.graph = graph;
        this.address = address;
        this.animate = animate;
    }

    @Override
    public IterationMode next(NaviNode node) {
        INaviFunctionNode functionNode;
        if (node.getRawNode() instanceof INaviCodeNode) {
            INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
            try {
                if (this.module.equals(codeNode.getParentFunction().getModule()) && ZyZoomHelpers.zoomToAddress(this.graph, this.address, this.animate, node, codeNode)) {
                    this.nodeFound = true;
                    return IterationMode.STOP;
                }
            }
            catch (MaybeNullException exception) {
                CUtilityFunctions.logException(exception);
            }
        } else if (node.getRawNode() instanceof INaviFunctionNode && this.module.equals((functionNode = (INaviFunctionNode)node.getRawNode()).getFunction().getModule()) && ZyZoomHelpers.zoomToAddress(this.graph, this.address, node, functionNode)) {
            this.nodeFound = true;
            return IterationMode.STOP;
        }
        return IterationMode.CONTINUE;
    }

    public boolean nodeFound() {
        return this.nodeFound;
    }
}

