/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Implementations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CodeNodeComments.DialogEditCodeNodeComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.FunctionComments.CDialogEditFunctionNodeComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InitialTab;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.TextNodeComments.DialogTextNodeComment;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;

public final class CNodeFunctions {
    private CNodeFunctions() {
    }

    private static JDialog getCommentDialog(CGraphModel model, INaviViewNode node, InitialTab initialTab) {
        if (node instanceof INaviCodeNode) {
            return new DialogEditCodeNodeComment(model, (INaviCodeNode)node, initialTab);
        }
        if (node instanceof INaviFunctionNode) {
            return new CDialogEditFunctionNodeComment(model, (INaviFunctionNode)node, initialTab);
        }
        throw new IllegalStateException("IE02127: Unknown node type");
    }

    private static void transferLocalCodeNodeComments(INaviCodeNode node, INaviCodeNode newNode1, INaviCodeNode newNode2) {
        newNode1.getComments().initializeLocalCodeNodeComment(node.getComments().getLocalCodeNodeComment());
        for (INaviInstruction naviInstruction : node.getInstructions()) {
            if (newNode1.hasInstruction(naviInstruction)) {
                newNode1.getComments().initializeLocalInstructionComment(naviInstruction, node.getComments().getLocalInstructionComment(naviInstruction));
                continue;
            }
            newNode2.getComments().initializeLocalInstructionComment(naviInstruction, node.getComments().getLocalInstructionComment(naviInstruction));
        }
    }

    public static ReilGraph copyReilCode(Window parent, INaviCodeNode node) {
        ReilTranslator<INaviCodeNode> translator = new ReilTranslator<INaviCodeNode>();
        try {
            return translator.translate((ITranslationEnvironment)new StandardEnvironment(), node);
        }
        catch (InternalTranslationException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E000XXX: Could not show REIL code for node";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not show the REIL code for basic block at '%X'.", node.getAddress()), new String[]{"The instructions could not be converted to REIL code."}, new String[]{"You can not fix this problem yourself. Please contact the BinNavi support."});
            NaviErrorDialog.show(parent, "E000XXX: Could not show REIL code for node", description, e2);
            return null;
        }
    }

    public static void createCommentNode(JFrame parent, INaviView view, INaviViewNode node) {
        Preconditions.checkNotNull(parent, "IE02128: Parent argument can not be null");
        Preconditions.checkNotNull(view, "IE02129: View argument can not be null");
        Preconditions.checkNotNull(node, "IE01726: Node argument can not be null");
        CTextNode source = view.getContent().createTextNode(null);
        CNaviViewEdge edge = view.getContent().createEdge(source, node, EdgeType.TEXTNODE_EDGE);
        DialogTextNodeComment dlg = new DialogTextNodeComment((Window)parent, source);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        List<IComment> newComment = dlg.getComment();
        if (newComment == null) {
            view.getContent().deleteEdge(edge);
            view.getContent().deleteNode(source);
        }
    }

    public static void editNodeComments(CGraphModel model, INaviViewNode node, InitialTab initialTab) {
        Preconditions.checkNotNull(node, "IE02131: Node argument can not be null");
        JDialog dialog = CNodeFunctions.getCommentDialog(model, node, initialTab);
        GuiHelper.centerChildToParent(model.getParent(), dialog, true);
        dialog.setVisible(true);
    }

    public static void splitAfter(INaviView view, INaviCodeNode originalNode, INaviInstruction instruction) {
        Iterable oldInstructions = originalNode.getInstructions();
        if (instruction == Iterables.getLast(oldInstructions)) {
            return;
        }
        ArrayList<INaviInstruction> upperInstructions = new ArrayList<INaviInstruction>();
        ArrayList lowerInstructions = new ArrayList();
        ArrayList<INaviInstruction> currentInstructions = upperInstructions;
        for (INaviInstruction oldInstruction : oldInstructions) {
            currentInstructions.add(oldInstruction);
            if (oldInstruction != instruction) continue;
            currentInstructions = lowerInstructions;
        }
        INaviFunction parentFunction = null;
        try {
            parentFunction = originalNode.getParentFunction();
        }
        catch (MaybeNullException oldInstruction) {
            // empty catch block
        }
        CCodeNode newNode1 = view.getContent().createCodeNode(parentFunction, upperInstructions);
        CCodeNode newNode2 = view.getContent().createCodeNode(parentFunction, lowerInstructions);
        newNode1.setColor(originalNode.getColor());
        newNode1.setBorderColor(originalNode.getBorderColor());
        newNode2.setColor(originalNode.getColor());
        CNodeFunctions.transferLocalCodeNodeComments(originalNode, newNode1, newNode2);
        view.getContent().createEdge(newNode1, newNode2, EdgeType.JUMP_UNCONDITIONAL);
        for (INaviEdge incomingEdge : originalNode.getIncomingEdges()) {
            view.getContent().createEdge((INaviViewNode)incomingEdge.getSource(), newNode1, incomingEdge.getType());
        }
        for (INaviEdge outgoingEdge : originalNode.getOutgoingEdges()) {
            view.getContent().createEdge(newNode2, (INaviViewNode)outgoingEdge.getTarget(), outgoingEdge.getType());
        }
        view.getContent().deleteNode(originalNode);
    }
}

